/*******************************************************************************
 * Copyright (c) 2005, 2006 svnClientAdapter project and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     svnClientAdapter project committers - initial API and implementation
 ******************************************************************************/
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevision.Number;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/**
 * This is a base class for the JavaHL Adapter.  It allows the JavaHL
 * Adapter and the SVNKit Adapter to share most of their implementation.
 * 
 * The SVNKit Adapter works by providing an implementation of the JavaHL
 * SVNClientInterface. 
 *
 */
public abstract class AbstractJhlClientAdapter extends AbstractClientAdapter {

    public void addDirectory(File dir, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addDirectory(File dir, boolean recurse, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addFile(File file) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addFile(File[] file, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addNotifyListener(ISVNNotifyListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cancelOperation() throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void checkout(SVNUrl moduleName, File destPath, SVNRevision revision, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cleanup(File dir) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long commit(File[] paths, String message, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long commit(File[] paths, String message, boolean recurse, boolean keepLocks) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copy(File srcPath, File destPath) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copy(File srcPath, SVNUrl destUrl, String message) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copy(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File path, File outFile, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl url, SVNRevision oldUrlRevision, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File path, SVNUrl url, SVNRevision urlRevision, File outFile, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doExport(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doExport(File srcPath, File destPath, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doImport(File path, SVNUrl url, String message, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getAdminDirectoryName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream getContent(SVNUrl url, SVNRevision revision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream getContent(File path, SVNRevision revision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry getDirEntry(SVNUrl url, SVNRevision revision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry getDirEntry(File path, SVNRevision revision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNInfo getInfo(File file) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNInfo getInfo(SVNUrl url, SVNRevision revision, SVNRevision peg) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNInfo getInfoFromWorkingCopy(File file) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry[] getList(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd, boolean fetchChangePath) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, String[] paths, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean fetchChangePath) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNNotificationHandler getNotificationHandler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty[] getProperties(File path) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty[] getProperties(SVNUrl url) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNStatus getSingleStatus(File path) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNStatus[] getStatus(File[] path) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAdminDirectory(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void lock(SVNUrl[] paths, String comment, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void lock(File[] paths, String comment, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mkdir(SVNUrl url, String message) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mkdir(File file) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void move(File srcPath, File destPath, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void move(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void propertyDel(File path, String propertyName, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty propertyGet(File path, String propertyName) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNProperty propertyGet(SVNUrl url, SVNRevision revision, SVNRevision peg, String propertyName) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void propertySet(File path, String propertyName, String propertyValue, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void propertySet(File path, String propertyName, File propertyFile, boolean recurse) throws SVNClientException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void relocate(String from, String to, String path, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void remove(SVNUrl[] url, String message) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void remove(File[] file, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeNotifyListener(ISVNNotifyListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resolved(File path) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void revert(File path, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void revert(File[] path, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setConfigDirectory(File dir) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setPassword(String password) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRevProperty(SVNUrl path, Number revisionNo, String propName, String propertyData, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setUsername(String username) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unlock(SVNUrl[] paths, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unlock(File[] paths, boolean force) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long update(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long[] update(File[] path, SVNRevision revision, boolean recurse, boolean ignoreExternals) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

}
