$:.unshift "../lib"

require 'test/unit'
require 'needle'
require 'needle/extras/require-library'

class TC_RequireLibrary_Container < Test::Unit::TestCase

  def test_require_library_registered
    reg = Needle::Registry.new
    assert !reg.keys.include?( :multicast )
    reg.require_library "needle/extras"
    assert reg.keys.include?( :multicast )
  end

  def test_require_library_unregistered
    reg = Needle::Registry.new
    assert_nothing_raised do
      reg.require_library "rational"
    end
  end

  def test_require_library_custom_hook
    called_by = nil
    Needle::LIBRARIES['yaml'] = lambda { |container| called_by = container }
    reg = Needle::Registry.new
    reg.require_library "yaml"
    assert_same called_by, reg
  end

end

class TC_RequireLibrary_Needle < Test::Unit::TestCase

  Klass = Class.new do
    attr_reader :events

    def method_missing( sym, *args )
      @events ||= []
      @events << [ sym, *args ]
    end
  end

  def test_register_library
    mod = Klass.new

    assert !Needle::LIBRARIES.has_key?( "openssl" )
    Needle.register_library( "openssl", mod )
    assert Needle::LIBRARIES.has_key?( "openssl" )

    reg = Needle::Registry.new
    reg.require_library "openssl"

    assert_equal [ [ :register_services, reg ] ], mod.events
  end

  def test_register_library_custom_method
    mod = Klass.new

    assert !Needle::LIBRARIES.has_key?( "net/http" )
    Needle.register_library( "net/http", mod, :register_foo )
    assert Needle::LIBRARIES.has_key?( "net/http" )

    reg = Needle::Registry.new
    reg.require_library "net/http"

    assert_equal [ [ :register_foo, reg ] ], mod.events
  end

end
