dnl
dnl Local autoconf definitions. Try to follow the guidelines of the autoconf
dnl macro repository so that integration in the repository is easy.
dnl To submit a macro to the repository send the macro (one macro per mail)
dnl to Peter Simons <simons@computer.org>.
dnl The repository itself is at http://www.gnu.org/software/ac-archive/
dnl

dnl @synopsis CHECK_MYSQL()
dnl
dnl This macro searches for an installed mysql library. If nothing
dnl was specified when calling configure, it searches first in /usr/local
dnl and then in /usr. If the --with-mysql=DIR is specified, it will try
dnl to find it in DIR/include/mysql/mysql.h and DIR/lib/libmysqlclient.a. 
dnl
dnl In the event where mysql is installed in two different trees (it is
dnl the case when --prefix is distinct from --exec-prefix), one can use
dnl the --with-mysql-include=DIR and --with-mysql-lib=DIR options to 
dnl specify the exact location of the headers and library directories.
dnl
dnl Examples:
dnl ./configure --with-mysql=$HOME/local
dnl ./configure --with-mysql-lib=$HOME/local/sparc/lib/mysql \
dnl             --with-mysql-include=$HOME/local/include/mysql
dnl
dnl If either the header file (mysql.h) or the library (libmysqlclient_r or
dnl libmysqlclient, in this order) are not found, the configuration exits
dnl on error.
dnl
dnl @version $Id: acinclude.m4,v 1.6 2002/07/05 14:25:50 gmorin Exp $
dnl @author Loic Dachary <loic@senga.org>
dnl
AC_DEFUN([CHECK_MYSQL],[

AC_ARG_WITH(mysql,
  AC_HELP_STRING([--with-mysql=DIR],[ root directory path of mysql installation (defaults to /usr/local or /usr if not found in /usr/local) ]),
  [case "${withval}" in
    yes|no) AC_MSG_ERROR("do not use --without-mysql because MySQL is mandatory");;
    *) MYSQL_HOME="$withval" ;;
   esac],
  [if test -z "${MYSQL_HOME}" ; then
	MYSQL_HOME=/usr/local
	if test ! -f "${MYSQL_HOME}/include/mysql/mysql.h" ; then
		MYSQL_HOME=/usr
	fi
   fi
])

AC_ARG_WITH(mysql_include,
  AC_HELP_STRING([--with-mysql-include=DIR],[ directory path of mysql include files (defaults to /usr/local/include/mysql or /usr/include/mysql) ]),
  [case "${withval}" in
    yes|no) AC_MSG_ERROR("do not use --without-mysql-include because MySQL is mandatory");;
    *) MYSQL_INCLUDE="$withval" ;;
   esac],
  [if test -z "$MYSQL_INCLUDE"; then
	MYSQL_INCLUDE=${MYSQL_HOME}/include/mysql
   fi
])

if test ! -f "${MYSQL_INCLUDE}/mysql.h"; then
	AC_MSG_ERROR([ ${MYSQL_INCLUDE}/mysql.h is not an existing file, use --with-mysql or --with-mysql-include options ])
fi

AC_ARG_WITH(mysql_lib,
  AC_HELP_STRING([--with-mysql-lib=DIR],[directory path of mysql libraries (defaults to /usr/local/lib/mysql or /usr/lib/mysql) ]),
  [case "${withval}" in
    yes|no) AC_MSG_ERROR([do not use --without-mysql-lib because MySQL is mandatory]);;
    *) MYSQL_LIB="$withval" ;;
   esac],
  [if test -z "$MYSQL_LIB"; then
	MYSQL_LIB=${MYSQL_HOME}/lib/mysql
   fi
])

if test ! -f "${MYSQL_LIB}/libmysqlclient.a"; then
	if test -f "${MYSQL_HOME}/lib/libmysqlclient.a"; then
		MYSQL_LIB=${MYSQL_HOME}/lib
	else
		AC_MSG_ERROR([${MYSQL_LIB}/libmysqlclient.a is not an existing file, use --with-mysql or --with-mysql-lib options])
	fi
fi

AC_MSG_CHECKING(Mysql installation directory)

AC_MSG_RESULT([ lib = $MYSQL_LIB, include = $MYSQL_INCLUDE ])

LDFLAGS="-L${MYSQL_LIB} $LDFLAGS"
CPPFLAGS="-I${MYSQL_INCLUDE} $CPPFLAGS"

dnl AC_LANG_PUSH(C)
AC_CHECK_LIB([mysqlclient_r],
             [mysql_real_connect],
	     [LIBS=$LIBS-lmysqlclient_r],
	     [
		AC_CHECK_LIB([mysqlclient],
			     [mysql_real_connect],
			     [
	                      AC_CHECK_LIB([mysqlclient],
	                                   [my_thread_init],
			                   [LIBS=$LIBS-lmysqlclient],
			                   [
					    AC_CHECK_LIB([mysys],
					                 [my_thread_init],
                                                         [ LIBS="$LIBS-lmysqlclient -lmysys"; AC_DEFINE(INCLUDE_MY_SYS,1, [ do we have to include <mysql/my_sys.h> ] )],
							 [ AC_MSG_ERROR([the MySQL threadsafe functions cannot be found. Please install libmysys])]
					    )
					    ],
			      )
			     ],
			     [AC_MSG_ERROR([no libmysqclient or libmysqclient_r found try running configure --with-mysql=DIR or --with-mysql-lib=DIR options])]
			    )
	     ]
            )

AC_CHECK_HEADERS([mysql.h],,
                 [AC_MSG_ERROR([mysql.h was not found try running configure with --with-mysql=DIR or --with-mysql-include=DIR options])]
                )
dnl AC_LANG_POP
])
