%define _unpackaged_files_terminate_build 1
%define enable_debug 0

Summary: PAM module for local authentication using RSA keypairs
Name: pam_rsa
Version: 0.8
Release: 9
Source: %{name}-%{version}-%{release}.tar.gz
URL: http://www.helsinki.fi/~vmkari/pamrsa
Group: System Environment/Base
Provides: pam_rsa
License: LGPL
Vendor: Laamanaama Software
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Requires: pam, openssl >= 0.9.7, bash
BuildRequires: pam-devel >= 0.77, openssl-devel >= 0.9.7
Packager: %{packer}

# Disable automatic generation of dependencies
Autoreq: 0

%description 
The pam_rsa is a PAM module (pluggable authentication module) that can 
authenticate local users using RSA keypairs. Public keys in X509 
PEM-format certificates are stored on a target host's file system. When 
a local user wants to authenticate to a PAM-aware service (e.g. login, 
gdm, su), he must show his private key to the host. The private key 
could be stored on a removable USB memory stick, for example.

%prep
%setup -q -n %{name}-%{version}-%{release}

%build
./configure --prefix=${RPM_BUILD_ROOT} --mandir=${RPM_BUILD_ROOT}%{_mandir} \
%if %{enable_debug}
	--enable-debug=yes 
%endif

make

%install
[ ${RPM_BUILD_ROOT} != "/" ] && rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/lib/security || exit 1
mkdir -p ${RPM_BUILD_ROOT}/usr/local/bin || exit 1
mkdir -p ${RPM_BUILD_ROOT}/etc/security || exit 1
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8 || exit 1
make install

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%pre

%post

%preun

%postun

%files
%defattr(-, root, root)
%attr(0755, root, root) /lib/security/pam_rsa.so
%attr(0755, root, root) /usr/local/bin/pamrsakp
%attr(0644, root, root) %config(noreplace) /etc/security/pamrsakp.cnf
%attr(0644, root, root) %{_mandir}/man8/pam_rsa.8.gz
%attr(0644, root, root) %{_mandir}/man8/pamrsakp.8.gz
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README TODO LGPL THANKS
%doc doc/examples/pam_rsa.conf.EXAMPLE doc/examples/auto.master.EXAMPLE doc/examples/auto.pamrsa.EXAMPLE
%doc doc/pam_rsa.html


%changelog
* Mon Mar 27 2006 Vesa-Matti Kari
- Added safety checks for directory and file modes
* Sat Mar 11 2006 Vesa-Matti Kari
- Created
