/****************************************************************************

 Copyright (C) 2002-2007 Gilles Debunne (Gilles.Debunne@imag.fr)

 This file is part of the QGLViewer library.
 Version 2.2.6-3, released on August 28, 2007.

 http://artis.imag.fr/Members/Gilles.Debunne/QGLViewer

 libQGLViewer is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 libQGLViewer is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with libQGLViewer; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*****************************************************************************/

#include "undo.h"
#include <qstring.h>

void Undo::clear()
{
  index_ = 0;
  maxIndex_ = 0;
  state_.clear();
}

void Undo::addState(const QString& s)
{
  if (index_ < int(state_.size()))
    state_[index_] = s;
  else
    state_.append(s);
  
  index_++;
  maxIndex_ = index_;
}

QString Undo::undoState()
{
  if (index_ > 1)
    {
      index_--;
      return state_[index_-1];
    }
  else
      return QString();
}

QString Undo::redoState()
{
  if (index_ < maxIndex_)
    {
      index_++;
      return state_[index_-1];
    }
  else
    return QString();
}

std::ostream& operator<<(std::ostream& out, const Undo& u)
{
  out << std::endl << u.index_ << ' ' << u.maxIndex_ << std::endl;

  for (int i=0; i<u.maxIndex_; ++i)
#if QT_VERSION < 0x040000
    out << u.state_[i].ascii() << std::endl;
#else
    out << u.state_[i].toLatin1().constData() << std::endl;
#endif

  return out;
}

std::istream& operator>>(std::istream& in, Undo& u)
{
  u.state_.clear();
  u.index_ = u.maxIndex_ = 0;
  in >> u.index_ >> u.maxIndex_;

  char str[10000];
  for (int i=0; i<u.maxIndex_; ++i)
    {
      in >> str;
      u.state_.append(str);
    }

  return in;
}
