/*
  imho_czech.pike v0.1 for IMHO v0.96.3
  
  Copyright  
  Petr Mifek <petr@kup.to> 1999
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

// Messages
//
//login
#define M_LOGIN 1
#define M_PASSWORD 2
#define M_NOLOGIN 3
#define M_IMAPERROR 10
#define M_SMTPERROR 11
#define M_SAVEDUSERINTERFACE 12
#define M_USERINTERFACE 13
#define M_LOGIN_OK 14
// page header
#define M_NEWMAIL 50
#define M_MAILBOX 51
#define M_MAILBOXES 52
#define M_FILES 53
#define M_PREFS 54
#define M_LOGOUT 55
#define M_CURRMAILBOX 56
#define M_CHECKACTIVEMAILBOXES 57
// compose
#define M_SEND 100
#define M_CANCELSEND 101
#define M_SENDMOREFILES 102
#define M_COMPOSEMAIL 103
#define M_SPELLCHECK 104
#define M_DONTSAVEMAIL 105
#define M_ADDFILEASATTACHMENT 106
#define M_NOATTACHMENTS 107
#define M_ADDATTACHMENT 108
#define M_REMOVEMARKEDATTACHMENTS 109
#define M_UPLOADATTACHMENT 110
#define M_ADDMARKEDTOATTACHMENTS 111
#define M_UPLOADTOATTACHMENTS 112
#define M_BACKTOCOMPOSE 113
#define M_NOATTACHFILES 114
#define M_ATTACHMENTSHEADER 115
#define M_SENDSAVEFAILED 116
#define M_SENDNORECV 117
// mailindex
#define M_DELETEMARKED 200
#define M_MOVEMARKED 201
#define M_SELECTMBOX 202
#define M_CHECKNEWMAIL 203
#define M_MAILSHOWN 204
#define M_BACKN 205
#define M_FORWARDN 206
#define M_NUMBER 207
#define M_DELETEMARKEDP 208
#define M_DELETEMARKEDNONE 209
#define M_CHANGESORTORDER 210
#define M_MOVETOTRASH 211
#define M_DELETEALLTRASH 212
#define M_NOMAILS 213
// mailboxlist
#define M_MBOXNAME 300
#define M_DELETEMARKEDMBOX 301
#define M_CREATEMBOX 302
#define M_NEWMBOXNAME 303
#define M_MBOXREMOVEP 350
#define M_MBOXMARKONE 351
#define M_NEWMBOXNONAME 352
#define M_CREATEMBOXERROR 353
#define M_INBOX 354
#define M_PREVIOUS_LEVEL 355
#define M_FOLDER_PATH 356
// files
#define M_FILENAME 400
#define M_SIZE 401
#define M_MIMETYPE 402
#define M_DELETEMARKEDFILES 403
#define M_UPLOAD 404
#define M_AVAILSPACE 405
#define M_WINDOWSBUG 406
#define M_NOFILES 407
// preferences
#define M_PNAME 500
#define M_PMAILADDRESS 501
#define M_PMAILPATH 502
#define M_PINCLUDEMAIL 503
#define M_PQUOTEPREFIX 504
#define M_PSIGNATURE 505
#define M_PINACTIVELOGOUT 506
#define M_PSAVEANDUSE 550
#define M_PVISIBLEMESSAGES 507
#define M_PSORTORDER 508
#define M_PSORTORDERS 509
#define M_PTRASHFOLDER 510
#define M_PSENTFOLDER 511
#define M_PDEFAULTBCC 512
#define M_PSAVEATTACHMENTS 513
#define M_PLANGUAGE 514
#define M_PUSERINTERFACE 515
#define M_PINBOXES 516
#define M_PCOMMASEPARATED 517
// logout
#define M_LOGOUTMSG 600
#define M_LOGGEDOUT 601
// dialog
#define M_QUESTION 700
#define M_INFO 701
// readmail
#define M_REPLY 800
#define M_READPREV 801
#define M_READNEXT 802
#define M_ATTACHMENTLINK 803
#define M_MAILMISSING 804
#define M_MAILMISSINGBACK 805
#define M_DELETE 806
#define M_FORWARD 807
#define M_MAIL 808
#define M_SHOWFULLHEADERS 809
#define M_HIDEFULLHEADERS 810
#define M_MAILTOOBIG 811
//spellcheck
#define M_SPELLDONE 900
#define M_SPELLPREV 901
#define M_SPELLNEXT 902
#define M_SPELLCHANGETO 903
#define M_SPELLSUGGESTIONS 904
// mailheaders
#define M_FROM 1000
#define M_TO 1001
#define M_CC 1002
#define M_BCC 1003
#define M_SUBJECT 1004
#define M_ATTACHMENTS 1005
#define M_TIME 1006
#define M_DATE 1007
// table heads
#define M_MARKFLAG 1100
#define M_NEWFLAG 1101
#define M_ANSWEREDFLAG 1102
// address book
#define M_ADDRESSBOOKTITLE 1200
#define M_ADDRESSBOOK 1201
#define M_INDEXNAMERECIPIENT 1202
#define M_INDEXNAMEEDIT 1203
#define M_ADDRESS 1204
#define M_NOADDRESSES 1205
#define M_NEWADDRESS 1206
#define M_EDITADDRESS 1207
#define M_ADDADDRESS 1208
#define M_INDEXNAME 1209
#define M_ADDRESSFORMAT 1210
#define M_SAVEADDRESS 1211
#define M_DELETEADDRESS 1212
#define M_CANCELADDRESS 1213
#define M_CANNOTIMPORT 1214
#define M_IMPORTADDRESSBOOKTITLE 1215
#define M_UPLOADADDRESSBOOK 1216
#define M_PINELOCATION 1217
#define M_UPLOADANDIMPORT 1218
#define M_IMPORTADDRESSBOOK 1219
//ldap support
#define M_LDAPTITLE 1300
#define M_LDAP 1301
#define M_SEARCHLDAP 1302
#define M_NAMECONT 1303
// general
#define M_YES 2000
#define M_NO 2001
#define M_DIALOGOK 2002
#define M_DIALOGCANCEL 2003

string imho_lang() {
  return "czech";
}

string imho_lang_short() {
  return "cz";
}

string imho_lang_charset() {
  return "iso-8859-2";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Jmno:";
  case M_PASSWORD:
    //return "Password:";
    return "Heslo:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>Nespn pihlen:</b> patn jmno nebo heslo. Prosm zkuste to znovu. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Nelze navzat spojen s potovnm (IMAP) serverem. Kontaktujte, prosm, sprvce systmu.";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Nelze navzat spojen s odchozm potovnm (SMTP) serverem. Kontaktujte, prosm, sprvce systmu.";
  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "Z nastaven";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Uivatelsk rozhran:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";

  case M_NEWMAIL:
    //return "New mail";
    return "Nov zprva";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Potovn schrnka: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Potovn schrnky";
  case M_FILES:
    //return "Files";
    return "Soubory";
  case M_PREFS:
    //return "Preferences";
    return "Nastaven";
  case M_LOGOUT:
    //return "Logout";
    return "Odhlen";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Aktivn potovn schrnka";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Zkontroluj aktivn potovn schrnky";

  case M_FROM:
    //return "From";
    return "Od";
  case M_TO:
    //return "To";
    return "Pro";
  case M_CC:
    //return "Cc";
    return "Kopie pro";
  case M_BCC:
    //return "Bcc";
    return "Tajn kopie pro";
  case M_SUBJECT:
    //return "Subject";
    return "Pedmt";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Plohy";
  case M_TIME:
    //return "Time";
    return "as";
  case M_DATE:
    //return "Date";
    return "Datum";
    
  case  M_MARKFLAG:
    //return "M";
    return "Z";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "O";
    
    
  case M_SEND:
    //return "Send";
    return "Poli";
  case M_CANCELSEND:
    //return "Cancel";
    return "Zru";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Oznate soubory k odesln. Pidrte 'Ctrl' pro zvolen vce soubor.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Nov dopis";
  case M_SPELLCHECK:
    return "Zkouka pravopisu";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "Neukldat tento dopis.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Pidej soubor jako plohu";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "dn plohy";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Pidat plohu...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Odstranit oznaen plohy";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Upload plohy";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Pidej oznaen k plohm";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Upload k plohm";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Zpt k vytven dopisu";
  case M_NOATTACHFILES:
    //return "No files";
    return "dn soubory";
  case  M_ATTACHMENTSHEADER:
    return "Nzev plohy";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "Pota byla odeslna spn, avak selhalo uloen tto poty do pihrdky.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Muste zadat adresta dopisu.";

  case M_DELETEMARKED:
    //return "Delete marked";
    return "Sma oznaen";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Pesu oznaen do";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Zvolit potovn schrnku)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Zkus novou potu";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Dopis %d-%d z %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Zpt %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Vped %d >>]", @arg);
  case M_NUMBER:
    return "N&ordm;";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return sprintf("Chcete opravdu smazat %d oznaench zprv?", @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Nejprve prosm oznate nkter zprvy.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Zm poad vpisu";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Pesu oznaen do koe";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "Vysyp ko";
  case M_NOMAILS:
    // return "[No mails]";
    return "[dn zprvy]";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Potovn schrnka";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Sma oznaen";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Vytvo novou potovn schrnku";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Nzev)";

  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Opravdu chcete smazat tyto potovn schrnky?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Oznate alespo jednu potovn schrnku.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Zadejte nejprve nzev.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Nepovedlo se vytvoit potovn schrnku. Je mon, e jmno nen povolen, nebo ji existuje schrnka se stejnm nzvem.";
  case M_INBOX:
    //return "Inbox";
    return "Pchoz";
  case M_PREVIOUS_LEVEL:
    //return "[Previuos level]";
    return "[Pedchoz rove]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Cesta:";
	
  case M_FILENAME:
    //return "Filename";
    return "Nzev souboru";
  case M_SIZE:
    //return "Size";
    return "Velikost";
  case M_MIMETYPE:
    //return "Type";
    return "Typ";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Sma oznaen";
  case M_UPLOAD:
    //return "Upload";
    return "Upload";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Mte k dispozici %d Kb pro upload.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Uivatel Windows: Kvli chybm v nkterch prohlech mohou bt pokozeny nzvy soubor. Pokozen nzv mete zabrnit pepsnm poslednch '\\' na '\\\\'  ped zmknutm tlatka 'Upload'.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Nemte dne uploadnut soubory.";

  case M_PNAME:
    //return "Name";
    return "Jmno";
  case M_PMAILADDRESS:
    //return "email";
    return "E-Mail";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Cesta hledn dopisu";

  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Piloit text zprvy pi odpovdi";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefix";
  case M_PSIGNATURE:
    //return "Signature";
    return "Podpis";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Odhlsit pi neinnosti (minuty)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Ulo a pouij";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Zprvy zobrazen v potovn schrnce";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Poad azen zprv";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "vped": "vped", "zpt":"zpt"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Ko";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Odeslan pota";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Implicitn adresa tajn kopie";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Ulo plohy";
  case M_PLANGUAGE:
    //return "Language";
    return "Jazyk";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Uivatelsk prosted";

  case M_PINBOXES:
    //return "Inboxes";
    return "Schrnky pchoz poty";
  case M_PCOMMASEPARATED: 
    //return "(Comma separated list of mailboxes)";
    return "(Seznam schrnek pchoz poty oddlen rkami)";

  case M_SPELLDONE:
    //return "Done";
    return "Hotovo";
  case M_SPELLPREV:
    //return "Previous";
    return "Pedchoz";
  case M_SPELLNEXT:
    //return "Next";
    return "Nsledujc";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "Zm na";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Nvrhy";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mails.<br><br>Reload this page to login.";
    return "Jste odhlen(a). Zavete tohle okno pro jistotu, e si nikdo nebude moci pest Vai potu.<br><br>Obnovte tuto strnku pro pihlen.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Uivatel odhlen";

  case M_QUESTION:
    //return "Question"; 
    return "Otzka";
  case M_INFO:
    //return "Info"; 
    return "Info";

  case M_REPLY:
    //return "Reply";
    return "Odpovet";

  case M_READPREV:
    //return "Read previous";
    return "Pest pedchoz";
  case M_READNEXT:
    //return "Read next";
    return "Pest nsledujc";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sploha typu %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Chyba:</b> Penos zprvy se nezdail. Prosm zkuste to znovu..<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Zpt";
  case M_DELETE:
    //return "Delete";
    return "Smazat";
  case M_FORWARD:
    //return "Vped";
    return "Pedat";
  case M_MAIL:
    // return "Mail";
    return "Zprva";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "Uka pln hlaviky";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "Schovej pln hlaviky";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "Zprva je pli velk ke zobrazen. Kliknte zde pro download.";
  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Adres");
  case M_ADDRESSBOOK:
    //return("Adress book...");
    return("Adres...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Jmno zznamu (kliknte pro pidn do pjemc)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Jmno zznamu (kliknte zde pro editaci)");
  case M_ADDRESS:
    //return("Address");
    return("Adresa");
  case M_NOADDRESSES:
    //return("No addresses");
    return("dn adresy");
  case M_NEWADDRESS:
    //return("New address...");
    return("Nov adresa...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Uprav adresu");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Pidej do adrese");
  case M_INDEXNAME:
    //return("Index name");
    return("Jmno zznamu");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Adresa(y), oddlen rkou");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Ulo a pouij");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Sma adresu");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Zru");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("Nemohu importovat tento adres, protoe jeho\nformt nebyl rozpoznn.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Importuj adres");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Upload adrese z Pine nebo exportovanho z Netscape (.ldif)");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("Adres Pine je obvykle v   ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Upload a importuj");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Importuj adres...");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("LDAP adresy");
  case M_LDAP:
    //return("LDAP");
    return("LDAP");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("Prohledej LDAP");
  case M_NAMECONT:
    //return("Search name containing:");
    return("Hledej jmno obsahujc:");

  case M_YES:
    //return "Yes";
    return "Ano";
  case M_NO:
    //return "No";
    return "Ne";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Zru";

  }
  return 0;
}





