/*
 * Programs.pike
 * (C) 1998, 1999 Francesco Chemolli <kinkie@kame.usr.dsi.unimi.it>
 * This program is freely redistributable under the terms of the GNU
 * General Public License, release 2.
 * This program comes with NO WARRANTY OF ANY KIND
 *
 * This is a pikescript for the Roxen webserver, whose purpose is to
 * manage the Pike Programs cache in the Pike Master Object.
 * When a program is loaded, it is cached by the master object. When
 * cloned thereafter, the cached copy will be used. This is not
 * a problem normally (for modules and pikescripts), but it _IS_
 * a problem if, for example, your pikescript inherits from something
 * and you want to reload that something.
 *
 * How to use it: invoke it, you'll be given a list of all the programs
 * in cache. Click on "delete" to delete one. Reload to refresh.
 * Simple, isn't it? What did you expect in 35 lines of code anyways? :-P
 */

inherit "roxenlib";

void delete_programs() {
	master()->programs=([]);
}

void delete_program(string name) {
	m_delete(master()->programs,name);
}

mapping parse (object id) {
	if (search(id->raw_url,"?")<0)
		return http_redirect(id->not_query+"?",id);
	array programs=Array.map(sort(indices(master()->programs)),
			lambda(string s, object id) {
			return sprintf("<A href=%s?delete=%s>delete</A> %s",
					id->not_query,s,s);
				}
				,id
			);
	string retval= replace(programs*"\n", "\n", "<BR>\n");
	if (id->variables->delete) {
		delete_program(id->variables->delete);
		return http_redirect(id->not_query+"?",id);
		}
	if (id->variables->deleteall) {
		delete_programs();
		return http_redirect(id->not_query+"?",id);
	} else {
		retval += "<P><A href=\""+id->not_query+"?deleteall=1\">Cancella tutto</A>";
	}
	return http_string_answer (retval,"text/html");
}

int no_reload (object id) {
	if (id->variables->reload||id->config->reload||id->config->debug)
		return 0;
	return 1;
}
