/*
 * libSpiff - XSPF playlist handling library
 *
 * Copyright (C) 2006 Sebastian Pipping
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Sebastian Pipping, webmaster@hartwork.org
 */

#include "OfficialSuite.h"
using namespace Spiff;



#undef SEP
#if (defined(__WIN32__) || defined(WIN32))
# define SEP _PT("\\")
#else
# define SEP _PT("/")
#endif

#ifndef SPIFF_SRCDIR
# define SPIFF_SRCDIR "."
#endif

#define V0_FAIL_PATH     _PT(SPIFF_SRCDIR) SEP _PT("test") SEP _PT("for_version_0") SEP _PT("fail") SEP
#define V0_PASS_PATH     _PT(SPIFF_SRCDIR) SEP _PT("test") SEP _PT("for_version_0") SEP _PT("pass") SEP
#define V1_FAIL_PATH     _PT(SPIFF_SRCDIR) SEP _PT("test") SEP _PT("for_version_1") SEP _PT("fail") SEP
#define V1_PASS_PATH     _PT(SPIFF_SRCDIR) SEP _PT("test") SEP _PT("for_version_1") SEP _PT("pass") SEP



OfficialSuite::OfficialSuite() {
	// version 0 / fail
	TEST_ADD(OfficialSuite::playlist_extension_forbidden)
	TEST_ADD(OfficialSuite::track_extension_forbidden)
	TEST_ADD(OfficialSuite::tracklist_no_tracks)

	// version 0 / pass
	// none yet

	// version 1 / fail
	TEST_ADD(OfficialSuite::playlist_attribute_forbidden_annotation)
	TEST_ADD(OfficialSuite::playlist_baddate)
	TEST_ADD(OfficialSuite::playlist_badversion)
	TEST_ADD(OfficialSuite::playlist_element_forbidden_attribution)
	TEST_ADD(OfficialSuite::playlist_markup_annotation)
	TEST_ADD(OfficialSuite::playlist_markup_creator)
	TEST_ADD(OfficialSuite::playlist_markup_meta)
	TEST_ADD(OfficialSuite::playlist_markup_title)
	TEST_ADD(OfficialSuite::playlist_missingtracklist)
	TEST_ADD(OfficialSuite::playlist_missingversion)
	TEST_ADD(OfficialSuite::playlist_namespace_missing)
	TEST_ADD(OfficialSuite::playlist_namespace_nested_broken)
	TEST_ADD(OfficialSuite::playlist_namespace_wrong_string)
	TEST_ADD(OfficialSuite::playlist_nonleaf_content_attribution)
	TEST_ADD(OfficialSuite::playlist_nonleaf_content_playlist)
	TEST_ADD(OfficialSuite::playlist_nonleaf_content_trackList)
	TEST_ADD(OfficialSuite::playlist_noturi_attribution_identifier)
	TEST_ADD(OfficialSuite::playlist_noturi_attribution_location)
	TEST_ADD(OfficialSuite::playlist_noturi_extension)
	TEST_ADD(OfficialSuite::playlist_noturi_identifier)
	TEST_ADD(OfficialSuite::playlist_noturi_image)
	TEST_ADD(OfficialSuite::playlist_noturi_info)
	TEST_ADD(OfficialSuite::playlist_noturi_license)
	TEST_ADD(OfficialSuite::playlist_noturi_link_content)
	TEST_ADD(OfficialSuite::playlist_noturi_link_rel)
	TEST_ADD(OfficialSuite::playlist_noturi_location)
	TEST_ADD(OfficialSuite::playlist_noturi_meta)
	TEST_ADD(OfficialSuite::playlist_root_name)
	TEST_ADD(OfficialSuite::playlist_toomany_annotation)
	TEST_ADD(OfficialSuite::playlist_toomany_attribution)
	TEST_ADD(OfficialSuite::playlist_toomany_creator)
	TEST_ADD(OfficialSuite::playlist_toomany_date)
	TEST_ADD(OfficialSuite::playlist_toomany_identifier)
	TEST_ADD(OfficialSuite::playlist_toomany_image)
	TEST_ADD(OfficialSuite::playlist_toomany_info)
	TEST_ADD(OfficialSuite::playlist_toomany_license)
	TEST_ADD(OfficialSuite::playlist_toomany_location)
	TEST_ADD(OfficialSuite::playlist_toomany_title)
	TEST_ADD(OfficialSuite::playlist_toomany_tracklist)
	TEST_ADD(OfficialSuite::track_badint_duration)
	TEST_ADD(OfficialSuite::track_badint_tracknum)
	TEST_ADD(OfficialSuite::track_markup_album)
	TEST_ADD(OfficialSuite::track_markup_annotation)
	TEST_ADD(OfficialSuite::track_markup_creator)
	TEST_ADD(OfficialSuite::track_markup_meta)
	TEST_ADD(OfficialSuite::track_markup_title)
	TEST_ADD(OfficialSuite::track_nonleaf_content)
	TEST_ADD(OfficialSuite::track_noturi_extension)
	TEST_ADD(OfficialSuite::track_noturi_identifier)
	TEST_ADD(OfficialSuite::track_noturi_image)
	TEST_ADD(OfficialSuite::track_noturi_info)
	TEST_ADD(OfficialSuite::track_noturi_link)
	TEST_ADD(OfficialSuite::track_noturi_link_rel)
	TEST_ADD(OfficialSuite::track_noturi_location)
	TEST_ADD(OfficialSuite::track_noturi_meta_rel)
	TEST_ADD(OfficialSuite::track_toomany_album)
	TEST_ADD(OfficialSuite::track_toomany_annotation)
	TEST_ADD(OfficialSuite::track_toomany_creator)
	TEST_ADD(OfficialSuite::track_toomany_duration)
	TEST_ADD(OfficialSuite::track_toomany_image)
	TEST_ADD(OfficialSuite::track_toomany_info)
	TEST_ADD(OfficialSuite::track_toomany_title)
	TEST_ADD(OfficialSuite::track_toomany_tracknum)
	TEST_ADD(OfficialSuite::track_whitespace_in_between)
	TEST_ADD(OfficialSuite::xml_error)

	// version 1 / pass
	TEST_ADD(OfficialSuite::playlist_empty_annotation)
	TEST_ADD(OfficialSuite::playlist_empty_creator)
	TEST_ADD(OfficialSuite::playlist_empty_meta)
	TEST_ADD(OfficialSuite::playlist_empty_title)
	TEST_ADD(OfficialSuite::playlist_extension)
	TEST_ADD(OfficialSuite::playlist_extensive)
	TEST_ADD(OfficialSuite::playlist_inverted_order)
	TEST_ADD(OfficialSuite::playlist_namespace_nested_proper)
	TEST_ADD(OfficialSuite::playlist_namespace_nondefault)
	TEST_ADD(OfficialSuite::playlist_namespace_two_additions)
	TEST_ADD(OfficialSuite::playlist_whitespace_dateTime)
	TEST_ADD(OfficialSuite::track_empty_album)
	TEST_ADD(OfficialSuite::track_empty_annotation)
	TEST_ADD(OfficialSuite::track_empty_creator)
	TEST_ADD(OfficialSuite::track_empty_meta)
	TEST_ADD(OfficialSuite::track_empty_title)
	TEST_ADD(OfficialSuite::track_extension)
	TEST_ADD(OfficialSuite::track_extensive)
	TEST_ADD(OfficialSuite::track_inverted_order)
	TEST_ADD(OfficialSuite::track_whitespace_anyURI)
	TEST_ADD(OfficialSuite::track_whitespace_nonNegativeInteger)
}



void OfficialSuite::runCase(const XML_Char * filename, int expectedCode) {
	const int res = this->reader.parseFile(filename, NULL);

	if (res != expectedCode) {
		PORT_PRINTF(
				_PT("      File : %s\n")
				_PT("      Line : %i\n")
				_PT("Error text : '%s'\n")
				_PT("Error code : %i\n")
				_PT("  Expected : %i\n\n"),
				filename, reader.getErrorLine(),
				reader.getErrorText(), res, expectedCode);
	}

	TEST_ASSERT(res == expectedCode);
}



// version 0 / fail
void OfficialSuite::playlist_extension_forbidden() {
	runCase(V0_FAIL_PATH _PT("playlist-extension-forbidden.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::track_extension_forbidden() {
	runCase(V0_FAIL_PATH _PT("track-extension-forbidden.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::tracklist_no_tracks() {
	runCase(V0_FAIL_PATH _PT("tracklist-no-tracks.xspf"), SPIFF_READER_ERROR_ELEMENT_MISSING);
}




// version 0 / pass
// none yet

// version 1 / fail
void OfficialSuite::playlist_attribute_forbidden_annotation() {
	runCase(V1_FAIL_PATH _PT("playlist-attribute-forbidden-annotation.xspf"), SPIFF_READER_ERROR_ATTRIBUTE_FORBIDDEN);
}



void OfficialSuite::playlist_baddate() {
	runCase(V1_FAIL_PATH _PT("playlist-baddate.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_badversion() {
	runCase(V1_FAIL_PATH _PT("playlist-badversion.xspf"), SPIFF_READER_ERROR_ATTRIBUTE_INVALID);
}



void OfficialSuite::playlist_element_forbidden_attribution() {
	runCase(V1_FAIL_PATH _PT("playlist-element-forbidden-attribution.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::playlist_markup_annotation() {
	runCase(V1_FAIL_PATH _PT("playlist-markup-annotation.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::playlist_markup_creator() {
	runCase(V1_FAIL_PATH _PT("playlist-markup-creator.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::playlist_markup_meta() {
	runCase(V1_FAIL_PATH _PT("playlist-markup-meta.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::playlist_markup_title() {
	runCase(V1_FAIL_PATH _PT("playlist-markup-title.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::playlist_missingtracklist() {
	runCase(V1_FAIL_PATH _PT("playlist-missingtracklist.xspf"), SPIFF_READER_ERROR_ELEMENT_MISSING);
}



void OfficialSuite::playlist_missingversion() {
	runCase(V1_FAIL_PATH _PT("playlist-missingversion.xspf"), SPIFF_READER_ERROR_ATTRIBUTE_MISSING);
}



void OfficialSuite::playlist_namespace_missing() {
	runCase(V1_FAIL_PATH _PT("playlist-namespace-missing.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::playlist_namespace_nested_broken() {
	runCase(V1_FAIL_PATH _PT("playlist-namespace-nested-broken.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::playlist_namespace_wrong_string() {
	runCase(V1_FAIL_PATH _PT("playlist-namespace-wrong-string.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::playlist_nonleaf_content_attribution() {
	runCase(V1_FAIL_PATH _PT("playlist-nonleaf-content-attribution.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_nonleaf_content_playlist() {
	runCase(V1_FAIL_PATH _PT("playlist-nonleaf-content-playlist.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_nonleaf_content_trackList() {
	runCase(V1_FAIL_PATH _PT("playlist-nonleaf-content-trackList.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_noturi_attribution_identifier() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-attribution-identifier.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_noturi_attribution_location() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-attribution-location.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_noturi_extension() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-extension.xspf"), SPIFF_READER_ERROR_ATTRIBUTE_INVALID);
}



void OfficialSuite::playlist_noturi_identifier() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-identifier.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_noturi_image() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-image.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_noturi_info() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-info.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_noturi_license() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-license.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_noturi_link_content() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-link-content.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_noturi_link_rel() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-link-rel.xspf"), SPIFF_READER_ERROR_ATTRIBUTE_INVALID);
}



void OfficialSuite::playlist_noturi_location() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-location.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::playlist_noturi_meta() {
	runCase(V1_FAIL_PATH _PT("playlist-noturi-meta.xspf"), SPIFF_READER_ERROR_ATTRIBUTE_INVALID);
}



void OfficialSuite::playlist_root_name() {
	runCase(V1_FAIL_PATH _PT("playlist-root-name.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::playlist_toomany_annotation() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-annotation.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_attribution() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-attribution.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_creator() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-creator.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_date() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-date.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_identifier() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-identifier.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_image() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-image.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_info() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-info.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_license() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-license.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_location() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-location.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_title() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-title.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::playlist_toomany_tracklist() {
	runCase(V1_FAIL_PATH _PT("playlist-toomany-tracklist.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::track_badint_duration() {
	runCase(V1_FAIL_PATH _PT("track-badint-duration.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::track_badint_tracknum() {
	runCase(V1_FAIL_PATH _PT("track-badint-tracknum.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::track_markup_album() {
	runCase(V1_FAIL_PATH _PT("track-markup-album.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::track_markup_annotation() {
	runCase(V1_FAIL_PATH _PT("track-markup-annotation.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::track_markup_creator() {
	runCase(V1_FAIL_PATH _PT("track-markup-creator.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::track_markup_meta() {
	runCase(V1_FAIL_PATH _PT("track-markup-meta.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::track_markup_title() {
	runCase(V1_FAIL_PATH _PT("track-markup-title.xspf"), SPIFF_READER_ERROR_ELEMENT_FORBIDDEN);
}



void OfficialSuite::track_nonleaf_content() {
	runCase(V1_FAIL_PATH _PT("track-nonleaf-content.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::track_noturi_extension() {
	runCase(V1_FAIL_PATH _PT("track-noturi-extension.xspf"), SPIFF_READER_ERROR_ATTRIBUTE_INVALID);
}



void OfficialSuite::track_noturi_identifier() {
	runCase(V1_FAIL_PATH _PT("track-noturi-identifier.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::track_noturi_image() {
	runCase(V1_FAIL_PATH _PT("track-noturi-image.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::track_noturi_info() {
	runCase(V1_FAIL_PATH _PT("track-noturi-info.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::track_noturi_link() {
	runCase(V1_FAIL_PATH _PT("track-noturi-link.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::track_noturi_link_rel() {
	runCase(V1_FAIL_PATH _PT("track-noturi-link-rel.xspf"), SPIFF_READER_ERROR_ATTRIBUTE_INVALID);
}



void OfficialSuite::track_noturi_location() {
	runCase(V1_FAIL_PATH _PT("track-noturi-location.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::track_noturi_meta_rel() {
	runCase(V1_FAIL_PATH _PT("track-noturi-meta-rel.xspf"), SPIFF_READER_ERROR_ATTRIBUTE_INVALID);
}



void OfficialSuite::track_toomany_album() {
	runCase(V1_FAIL_PATH _PT("track-toomany-album.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::track_toomany_annotation() {
	runCase(V1_FAIL_PATH _PT("track-toomany-annotation.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::track_toomany_creator() {
	runCase(V1_FAIL_PATH _PT("track-toomany-creator.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::track_toomany_duration() {
	runCase(V1_FAIL_PATH _PT("track-toomany-duration.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::track_toomany_image() {
	runCase(V1_FAIL_PATH _PT("track-toomany-image.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::track_toomany_info() {
	runCase(V1_FAIL_PATH _PT("track-toomany-info.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::track_toomany_title() {
	runCase(V1_FAIL_PATH _PT("track-toomany-title.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::track_toomany_tracknum() {
	runCase(V1_FAIL_PATH _PT("track-toomany-tracknum.xspf"), SPIFF_READER_ERROR_ELEMENT_TOOMANY);
}



void OfficialSuite::track_whitespace_in_between() {
	runCase(V1_FAIL_PATH _PT("track-whitespace-in-between.xspf"), SPIFF_READER_ERROR_CONTENT_INVALID);
}



void OfficialSuite::xml_error() {
	runCase(V1_FAIL_PATH _PT("xml-error.xspf"), SPIFF_READER_ERROR_EXPAT + XML_ERROR_DUPLICATE_ATTRIBUTE);
}




// version 1 / pass
void OfficialSuite::playlist_empty_annotation() {
	runCase(V1_PASS_PATH _PT("playlist-empty-annotation.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_empty_creator() {
	runCase(V1_PASS_PATH _PT("playlist-empty-creator.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_empty_meta() {
	runCase(V1_PASS_PATH _PT("playlist-empty-meta.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_empty_title() {
	runCase(V1_PASS_PATH _PT("playlist-empty-title.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_extension() {
	runCase(V1_PASS_PATH _PT("playlist-extension.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_extensive() {
	runCase(V1_PASS_PATH _PT("playlist-extensive.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_inverted_order() {
	runCase(V1_PASS_PATH _PT("playlist-inverted-order.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_namespace_nested_proper() {
	runCase(V1_PASS_PATH _PT("playlist-namespace-nested-proper.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_namespace_nondefault() {
	runCase(V1_PASS_PATH _PT("playlist-namespace-nondefault.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_namespace_two_additions() {
	runCase(V1_PASS_PATH _PT("playlist-namespace-two-additions.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::playlist_whitespace_dateTime() {
	runCase(V1_PASS_PATH _PT("playlist-whitespace-dateTime.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_empty_album() {
	runCase(V1_PASS_PATH _PT("track-empty-album.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_empty_annotation() {
	runCase(V1_PASS_PATH _PT("track-empty-annotation.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_empty_creator() {
	runCase(V1_PASS_PATH _PT("track-empty-creator.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_empty_meta() {
	runCase(V1_PASS_PATH _PT("track-empty-meta.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_empty_title() {
	runCase(V1_PASS_PATH _PT("track-empty-title.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_extension() {
	runCase(V1_PASS_PATH _PT("track-extension.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_extensive() {
	runCase(V1_PASS_PATH _PT("track-extensive.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_inverted_order() {
	runCase(V1_PASS_PATH _PT("track-inverted-order.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_whitespace_anyURI() {
	runCase(V1_PASS_PATH _PT("track-whitespace-anyURI.xspf"), SPIFF_READER_SUCCESS);
}



void OfficialSuite::track_whitespace_nonNegativeInteger() {
	runCase(V1_PASS_PATH _PT("track-whitespace-nonNegativeInteger.xspf"), SPIFF_READER_SUCCESS);
}
