/* CellListCellRenderer.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.lists;

import java.awt.Graphics2D;

/**
 * Is responsible for painting a single element of a {@link CellList}.
 * This class plays the same role as a {@link javax.swing.ListCellRenderer} does
 * for a {@link javax.swing.JList} but with a different interface and contract.
 */
public interface CellListCellRenderer {
    
    
    /**
     * Return the tool tip text for the given element.
     * @param list The cell list to which the element belongs
     * @param value The corresponding value returned from the model
     * @param index The index of the cell in the list
     * @return the tool tip text for the cell, or <code>null</code>
     *   if no tool tip needs to be dipslayed
     */
    public String getToolTipText (CellList list, Object value, int index);
    
    /**
     * Paint the given element at the 0,0-position on the given graphics
     * context.
     * @param g2 Graphics context onto which the cell must be painted
     * @param list The cell list to which the element belongs
     * @param value The corresponding value returned from the model
     * @param index The index of the cell in the list
     * @param isSelected True if the specified cell was selected.
     * @param cellHasFocus True if the specified cell has the focus.
     */
    public void paintElement (Graphics2D g2, CellList list, Object value, int index,
            boolean isSelected, boolean cellHasFocus);
}
