'\"
'\" Generated from file 'img-tga.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
'\"
'\" -*- tcl -*- doctools
'\" -*- tcl -*- doctools = format-header.inc
.so man.macros
.TH "img-tga" n 1.3  "Img"
.BS
.SH "NAME"
img-tga \- Img, Truevision Targa Format (tga)
.SH "SYNOPSIS"
package require \fBTk \fR
.sp
package require \fBimg::tga  ?1.3?\fR
.sp
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
The package \fBimg::tga\fR is a sub-package of
\fBImg\fR. It can be loaded as a part of the complete Img support,
via \fBpackage require Img\fR, or on its own, via
\fBpackage require img::tga\fR.
.PP
Like all packages of \fBImg\fR it does \fInot\fR provide new
commands, but extends the existing \fBTk\fR command \fBimage\fR so
that it supports files containing raster images in the
Truevision Targa Format (tga). More specifically
\fBimg::tga\fR extends \fBTk\fR's \fBphoto\fR
image type.
.PP
The name of the new format handler is \fBtga\fR.
This handler provides new additional configuration options. See
section \fBTGA OPTIONS\fR for more detailed explanations.
'\" -*- tcl -*- doctools = format-middle.inc
.PP
All of the above means that in a call like
.TP
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?\fR
.IP [1]
Image data in tga format (options \fB-data\fR and \fB-file\fR) is
detected automatically.
.IP [2]
The format name \fBtga\fR is recognized by the option \fB-format\fR.
In addition the value for the option is treated as list and may
contain any of the special options listed in section
\fBTGA OPTIONS\fR.
.SH "SUPPORTED TGA TYPES"
.nf
 24-bit pixels: True-color (RGB, each channel 8 bit).
 32-bit pixels: True-color with alpha channel (RGBA, each channel 8 bit).

 List of currently supported features:

 Type   |     Read      |     Write     |
        | -file | -data | -file | -data |
 ----------------------------------------
 24-bit | Yes   | Yes   | Yes   | Yes   |
 32-bit | Yes   | Yes   | Yes   | Yes   |

 All images types may be either uncompressed (Targa-Type 2) or
 run-length encoded (Targa-Type 10).
.fi
.SH "TGA OPTIONS"
The handler provides the following options:
.TP
\fB-verbose\fR \fIbool\fR
This option is supported for reading and writing.
.sp
If set to \fBtrue\fR, additional information about the loaded/stored image
is printed to stdout. Default is \fBfalse\fR.
.TP
\fB-compression\fR \fItype\fR
This option is supported for writing only.
.sp
Set the compression mode to either \fBnone\fR or \fBrle\fR.
Default is \fBrle\fR.
.TP
\fB-matte\fR \fIbool\fR
This option is supported for reading and writing.
.sp
If set to \fBfalse\fR, a matte (alpha) channel is ignored
during reading or writing. Default is \fBtrue\fR.
'\" -*- tcl -*- doctools = format-footer.inc
.SH "SEE ALSO"
img-bmp, img-gif, img-ico, img-intro, img-jpeg, img-pcx, img-pixmap, img-png, img-ppm, img-ps, img-sgi, img-sun, img-tga, img-tiff, img-window, img-xbm, img-xpm
.SH "KEYWORDS"
image handling, tga, tk
.SH "COPYRIGHT"
.nf
Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
.fi
