/*******************

Written by Frank Rimlinger, May 1993
*******************/

#include "crossTrainer.h"
#include "FmapTreeInitInfo.h"
#include <stdio.h>
#include "FGLvar.h"
#include "FmapTree.h"

FmapTreeInitInfo::FmapTreeInitInfo(long numItems){

// numItems, this a a convenience for the overriding classes
	this->numItems=numItems;

// NAME
	sprintf((char *)errorStr,"mapTree"); // designation of GLvar for error handler
	CtoPstr((char *)errorStr);				  // use Pascal version

// WALKS
	IDactiveMax=1;				// number of simultaneously active walks

// PACKET SIZES	
	rNoEntries=numItems;	// real link of a real vertex
	iNoEntries=1;			// ideal link of an ideal vertex 			
	lutNoEntries=1;			// ideal vertex look-up table				
	ChildNoEntries=1064;		// child vertices generated by FGLwalkNode
	
// DATA
	useD=FALSE;
	DtypeSize=0;
	useiD=FALSE;
	iDtypeSize=0;

	
// RECYCLING
	recycleBlockSize=1064;
	recycleReal=TRUE;
	recycleIdeal=TRUE;
	
// BACKYARDS
	rBackYardSize=0;
	irBackYardSize=0;
	iBackYardSize=0;
	lutBackYardSize=0;
	
	rvBackYardSize=sizeof(long)+numItems*sizeof(Boolean);
	
	ivBackYardSize=0;
}
