
/**************************************************************************

        ex1a.c
        Colin Ramsay
        19 Jan 99

        ADAPTIVE COSET ENUMERATOR, Version 3.000

        Copyright 1999 
        Centre for Discrete Mathematics and Computing,
        Department of Mathematics and 
        Department of Computer Science & Electrical Engineering,
        The University of Queensland, QLD 4072.
	(http://www.csee.uq.edu.au/~havas/cdmc.html)

This is a simple example of how to drive ACE Level 1 (i.e., the core plus
the demo wrapper) directly.  No attempt is made to be terribly clever, or 
general purpose, or to do much error checking.  As our example, we use
F(2,7), which has order 29, and is generated by any of its generators (we 
use `e').  We use R*-style. This works quite nicely, with a `good' set of 
parameters being: 

Group Name: F(2,7);
Group Generators: a,b,c,d,e,f,g;
Group Relators: ab=c, bc=d, cd=e, de=f, ef=g, fg=a, ga=b;
Subgroup Name: trivial;
Subgroup Generators: ;
Wo:1000000; Max:71426; Mess:5000; Ti:-1; Ho:-1; Loop:0
As:0; Path:0; Row:1; Mend:0; No:7; Look:1; Com:10;
C:0; R:-1000; Fi:20; PMod:0; PSiz:256; DMod:3; DSiz:250;

**************************************************************************/

#include "al1.h"

#include <string.h>

#define R   rellst
#define RL  rellst->last
#define RLW rellst->last->word

void bld_pres(void)
  {
  int i;

  grpname = (char *)malloc(6+1);
  strcpy(grpname, "F(2,7)");

  ndgen = 7;
  galpha = TRUE;

  for (i = 0; i < 27; i++) 
    { algen[i] = '\0'; }
  algen[1] = 'a';			/* Generator 1 is 'a' ... */
  algen[2] = 'b';
  algen[3] = 'c';
  algen[4] = 'd';
  algen[5] = 'e';
  algen[6] = 'f';
  algen[7] = 'g';

  for (i = 0; i < 27; i++) 
    { genal[i] = 0; }
  genal[1] = 1;
  genal[2] = 2;
  genal[3] = 3;
  genal[4] = 4;
  genal[5] = 5;
  genal[6] = 6;
  genal[7] = 7;

  R = al1_newwl();

  R->first = RL = al1_newelt();
  R->len++;
  RLW = (int*)malloc((3+1)*sizeof(int));
  RLW[0] = 0;				/* Not used */
  RLW[1] = 1;				/* 'a' */
  RLW[2] = 2;				/* 'b' */
  RLW[3] = -3;				/* 'C' = 'c^-1' */
  RL->len = 3;
  RL->exp = 1;
  RL->next = NULL;

  RL = (RL->next = al1_newelt());
  R->len++;
  RLW = (int*)malloc((3+1)*sizeof(int));
  RLW[0] = 0;
  RLW[1] = 2;
  RLW[2] = 3;
  RLW[3] = -4;
  RL->len = 3;
  RL->exp = 1;
  RL->next = NULL;

  RL = (RL->next = al1_newelt());
  R->len++;
  RLW = (int*)malloc((3+1)*sizeof(int));
  RLW[0] = 0;
  RLW[1] = 3;
  RLW[2] = 4;
  RLW[3] = -5;
  RL->len = 3;
  RL->exp = 1;
  RL->next = NULL;

  RL = (RL->next = al1_newelt());
  R->len++;
  RLW = (int*)malloc((3+1)*sizeof(int));
  RLW[0] = 0;
  RLW[1] = 4;
  RLW[2] = 5;
  RLW[3] = -6;
  RL->len = 3;
  RL->exp = 1;
  RL->next = NULL;

  RL = (RL->next = al1_newelt());
  R->len++;
  RLW = (int*)malloc((3+1)*sizeof(int));
  RLW[0] = 0;
  RLW[1] = 5;
  RLW[2] = 6;
  RLW[3] = -7;
  RL->len = 3;
  RL->exp = 1;
  RL->next = NULL;

  RL = (RL->next = al1_newelt());
  R->len++;
  RLW = (int*)malloc((3+1)*sizeof(int));
  RLW[0] = 0;
  RLW[1] = 6;
  RLW[2] = 7;
  RLW[3] = -1;
  RL->len = 3;
  RL->exp = 1;
  RL->next = NULL;

  RL = (RL->next = al1_newelt());
  R->len++;
  RLW = (int*)malloc((3+1)*sizeof(int));
  RLW[0] = 0;
  RLW[1] = 7;
  RLW[2] = 1;
  RLW[3] = -2;
  RL->len = 3;
  RL->exp = 1;
  RL->next = NULL;

  subgrpname = (char *)malloc(7+1);
  strcpy(subgrpname, "trivial");

  genlst = NULL;
  }

void edit_pres(void)
  {
  strcpy(subgrpname, "self");

  genlst = al1_newwl();

  genlst->first = genlst->last = al1_newelt();
  genlst->len++;
  genlst->last->word = (int*)malloc((1+1)*sizeof(int));
  genlst->last->word[0] = 0;			/* Not used */
  genlst->last->word[1] = 5;			/* 'e' */
  genlst->last->len = 1;
  genlst->last->exp = 1;
  genlst->last->next = NULL;
  }

int main(void)
  {
  int i,j;

  al1_init();

  fprintf(fop, "\n%s (Level 1): example programme \"a\"\n", ACE_VER);
  fprintf(fop, "Start time: %s\n", al0_date());

  /* Setup with the 'good' set of parameters (remainder default) */

  rfactor1 = -1000;
  cfactor1 = 0;

  dedmode = 3;
  dedsiz1 = 250;

  /* If you want to play with the parameters, put stuff here ... */

  /* mendel = TRUE; */
  /* rfill = FALSE; */
  
  /* Create the table workspace */

  costable = 
    (int *)malloc((long)workspace*(long)workmult*(long)sizeof(int));

  /* Enumeration #1: Start, with the trivial subgroup. */

  fprintf(fop, "======== #1 ========\n");

  bld_pres();

  msgctrl = TRUE;
  msgincr = 5000;

  printf("\n");
  al0_dump(TRUE);
  printf("\n");
  al1_dump(TRUE);

  for (i = 0; i < 2; i++)
    {			/* Tests repeatability; 1st run is expensive! */
    printf("\n");
    al1_rslt(al1_start(0));
    }
  printf("\n");
  STATDUMP;

  printf("\n");
  al0_dump(TRUE);
  printf("\n");
  al1_dump(TRUE);

  /* Print 1st part of full table (includes all non-redundant cosets) */

  printf("\n");
  al1_prtct(1,48,1,TRUE,TRUE);

  /* Print only the non-redundant part of the table */

  printf("\n");
  al1_prtct(1,nextdf-1,1,FALSE,FALSE);

  /* Compact & print the full table */

  al0_compact();
  printf("\n");
  al1_prtct(1,nextdf-1,1,TRUE,TRUE);

  /* Enumeration #2: Redo, using generator 'e' as subgroup. */

  printf("\n");
  fprintf(fop, "======== #2 ========\n");

  edit_pres();

  msgincr = 1;
  msghol  = TRUE;

  printf("\n");
  al0_dump(TRUE);
  printf("\n");
  al1_dump(TRUE);

  printf("\n");
  al1_rslt(al1_start(2));
  printf("\n");
  STATDUMP;

  printf("\n");
  al0_dump(TRUE);
  printf("\n");
  al1_dump(TRUE);

  /* Print the `full' table.  We need to do this explicitly, since _prtct()
  won't let us print past nextdf-1 & we want to see the coincs in the 
  collapse! */

  printf("\n");
  printf("     |");
  for (i = 0; i < 7; i++)
    { printf("   %c   %c", 'a'+i, 'A'+i); }
  printf("\n");
  printf(" ----+");
  for (i = 0; i < 7; i++)
    { printf("--------"); }
  printf("\n");
  for (i = 1; i <= 29; i++)
    {
    printf("%4d |", i);
    for (j = 1; j <= ncol; j++)
      { printf("%4d", CT(i,j)); }
    printf("\n");
    }
  printf("\n");

  fprintf(fop, "====================\n\n");
  fprintf(fop, "Stop time: %s\n", al0_date());

  return(0);
  }

