/* This file is part of the KDE libraries
   Copyright (C) 2005 Waldo Bastian <bastian@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef AddressLabel_H
#define AddressLabel_H

#include <qlabel.h>

#include <kdelibs_export.h>

namespace Mailody
{

    class ToolTip;

/**
 * @short A replacement for QLabel that supports richtext and
 *        proper layout management
 *
 * @author Waldo Bastian <bastian@kde.org>
 */

/*
 * QLabel
 */
class AddressLabel : public QLabel {
  Q_OBJECT

public:
    /**
     * Default constructor.
     */
    AddressLabel( QWidget *parent, const char *name = 0 );

    int defaultWidth() const { return m_defaultWidth; }
    void setDefaultWidth(int defaultWidth);

    virtual QSize minimumSizeHint() const;
    virtual QSize sizeHint() const;
    QSizePolicy sizePolicy() const;

public slots:
    void setText( const QString & );

signals:
    void leftClicked(const QString&);
    void rightClicked(const QString&);

protected:
    virtual void mouseReleaseEvent ( QMouseEvent * e );
    virtual void mouseMoveEvent( QMouseEvent * e );
    virtual void contextMenuEvent ( QContextMenuEvent * e );
    virtual void virtual_hook( int id, void* data );
    int m_defaultWidth;

private:
    class AddressLabelPrivate;
    AddressLabelPrivate *d;
    ToolTip* m_tt;
};

}
#endif // AddressLabel_H
