'\"
'\" Copyright (c) 1993-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH array n 8.3 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
array \- 操纵数组变量
.SH 总览 SYNOPSIS
\fBarray \fIoption arrayName\fR ?\fIarg arg ...\fR?
.BE

.SH 描述 DESCRIPTION
.PP
 这个命令在由 \fIarrayName\fR 给出的变量上进行多种操作中的某一项。除了在后面为单独的命令(专门)指定之外，\fIarrayName\fR 必须是一个现存的数组变量的名字。\fIoption\fR 选项决定命令完成何种动作。合法的选项(可以用缩写)有:
.TP
\fBarray anymore \fIarrayName searchId\fR
如果在一次数组查找中还有元素等待处理则返回 1，如果所有元素都被返回过了则返回 0。\fISearchId\fR 指示在 \fIarrayName\fR 上检查哪个查找，它必须是从以前的 \fBarray startsearch\fR 调用返回的值。如果一个数组的某个元素有空名字时这个选项特别有用，因为从 \fBarray nextelement\fR 返回的值不能指示出查找是否完成。
.TP
\fBarray donesearch \fIarrayName searchId\fR
这个命令终止一个数组查找并销毁与这个查找有关的所有状态。\fISearchId\fR 指示在 \fIarrayName\fR 上要要销毁哪个查找，必须时在以前调用 \fBarray startsearch\fR 返回的值。返回一个空串。
.TP
\fBarray exists \fIarrayName\fR
如果 \fIarrayName\fR 是一个数组变量返回 1，如果没有叫这个名字的变量或是一个标量变量则返回 0。
.TP
\fBarray get \fIarrayName\fR ?\fIpattern\fR?
返回包含成对的元素的一个列表。每对的第一个元素是在 \fIarrayName\fR 中的元素名，每对的第二个元素是数组元素的值。没定义成对元素的次序。如果没指定 \fIpattern\fR，则数组的所有元素被包括在结果中，如果指定了 \fIpattern\fR，则结果中只包括那些名字匹配 \fIpattern\fRn 的元素(使用 \fBstring match\fR 的匹配规则)。如果 \fIarrayName\fR 不是一个数组变量的名字，或者数组不包含元素，则返回一个空列表。
.TP
\fBarray names \fIarrayName\fR ?\fIpattern\fR?
返回在一个列表，它包含数组中匹配 \fIpattern\fR 的所有元素的名字(使用 \fBstring match\fR 匹配规则)。 如果省略了 \fIpattern\fR 则命令返回在数组中所有元素的名字。如果在数组中没有(匹配的)元素，或者 \fIarrayName\fRe 不是一个数组变量的名字，则返回一个空串。
.TP
\fBarray nextelement \fIarrayName searchId\fR
返回在 \fIarrayName\fR 中下一个元素的名字，如果在这个查找中所有 \fIarrayName\fR 的元素都被已经被返回过了则返回空串。\fIsearchId\fR 参数标识一个查找，并且必须是 \fBarray startsearch\fR 命令的返回值。 警告: 如果从这个数组中添加或删除元素，那么自动的终止所有的查找，有如调用了 \fBarray donesearch\fR，这将导致对这些查找的 \fBarray nextelement\fR 操作失败。
.TP
\fBarray set \fIarrayName list\fR
设置在 \fIarrayName\fR 中的一个或多个元素的值。list 的形式必须与 \fBarray get\fR 返回的相同，由偶数个元素组成的。在 \fIlist\fR 中每个奇数元素被作为在 \fIarrayName\fR 中被作为一个元素名对待，后面跟随的 \fIlist\fR 中的元素被作为这个数组元素的新值使用。如果变量 \fIarrayName\fR 不存在并且 \fIlist\fR 是空, 建立是空值的 \fIarrayName\fR。
.TP
\fBarray size \fIarrayName\fR
返回一个给出在一个数组中的元素个数的一个十进制数的字符串。如果 \fIarrayName\fR 不是一个数组的名字则返回 0。
.TP
\fBarray startsearch \fIarrayName\fR
这个命令在用 \fIarrayName\fR 给出的数组上初始化一个逐个元素的查找，调用 \fBarray nextelement\fR 命令将返回在数组中单独元素的名字。在查找完成的时候，要调用 \fBarray donesearch\fR 命令。返回值是一个在 \fBarray nextelement\fR 和 \fBarray donesearch\fR 命令中必须要用的查找标识符；对同一个数组允许多个查找同时进行。

.VS 8.3

.TP
\fBarray unset \fIarrayName\fR ?\fIpattern\fR?
在一个数组中删除匹配 \fIpattern\fR 的所有元素(使用 \fBstring match\fR 的匹配规则)。如果 \fIarrayName\fR 不是一个数组变量的名字或在数组中没有匹配的元素，则返回一个空数组。如果是一个数组变量的名字并且省略了 \fIpattern\fR ，则命令删除整个数组。 

.VE 8.3

.SH 关键字 KEYWORDS
array, element names, search

.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/06/22
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
