'\"
'\" Copyright (c) 1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: dde.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: dde.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH dde n 8.1 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
dde \- 执行一个动态数据交换命令
.SH "总览 SYNOPSIS"
.sp
\fBpackage require dde 1.1\fR
.sp
\fBdde \fIservername \fR?\fItopic\fR?
.sp
\fBdde ?\-async?\fR \fIcommand service topic \fR?\fIdata\fR?
.BE

.SH "描述 DESCRIPTION"
.PP
当运行在 Microsoft Windows 下的时候，这个命令允许一个应用来发送动态数据交换(Dynamic Data Exchange：DDE)命令。动态数据交换是一种机制，在这里应用可以交换原始数据。每个 DDE 事务都需要一个\fI服务名(service name)\fR和一个\fI主题(topic)\fR。\fI服务名\fR和主题均由应用来定义；Tcl 使用的服务名是 \fBTclEval\fR，而主题名是用\fBdde servername \fR给出的解释器的名字。其他的应用有其自己的\fI服务名\fR和\fI主题\fR。例如，Microsoft Excel 的服务名是 \fBExcel\fR。
.PP
\fBdde\fR  命令的唯一的选项是:          
.TP
\fB\-async\fR
要求异步激发(invocation)。这只对\fBexecute\fR 子命令有效。正常的，\fBdde execute\fR 子命令等待直到命令完成，返回适当的出错信息。当使用了 \fB-async\fR  选项，命令立刻返回，不能获得出错信息。  

.SH "DDE 命令 COMMANDS"
.PP
下面的命令是完整的动态数据交换命令集的子集。 
.TP
\fBdde servername \fR?\fItopic\fR?
\fBdde servername\fR  用服务名 \fBTclEval\fR   和由 \fItopic \fR指定的主题名来把解释器注册为一个 DDE 服务器。如果没有给出 \fItopic\fR，\fBdde servername\fR返回当前的主题的名字，如果未被注册为一个服务则返回空串。      
.TP
\fBdde execute \fIservice topic data\fR
\fBdde execute\fR  接受 \fIdata\fR  并把它发送到由 \fIservice\fR  指示出的服务器并由 \fItopic \fR指示出主题。典型的，\fIservice\fR 是一个应用的名字，而 \fItopic\fR 是要在其上工作的一个文件。给予远程应用的是 \fIdata\fR 域(field)。典型的，应用把 \fIdata\fR  域作为脚本对待，接着在应用中运行脚本。如果脚本没有运行，命令返回一个错误。如果使用了 \fB-async\fR标志，命令立即返回而没有错误。               
.TP
\fBdde poke \fIservice topic item data\fR
\fBdde poke\fR  传递 \fIdata\fR  到由 \fIservice\fR指示的服务器并用 \fItopic\fR 和 \fIitem\fR  加以指定。典型的， \fIservice\fR  是一个应用的名字。\fItopic\fR 由应用指定，可以是给服务器的一个命令或一个要在其上工作的一个文件的名字。\fIitem\fR 也由应用指定，不常用，但必须总是非空。给予远程应用的是 \fIdata\fR  域( field)。                 
.TP
\fBdde request \fIservice topic item\fR
\fBdde request\fR  典型的用于得到某种东西的值；如 Microsoft Excel 中的一个单元格(cell)的值或在 Microsoft Word  中一个选择的文本。 \fIservice\fR 典型的是一个应用的名字。 \fItopic\fR典型的是文件的名字，\fIitem\fR由用户来指定。命令返回在应用中定义的 \fIitem\fR的值。
.TP
\fBdde services \fIservice topic\fR
\fBdde services\fR  返回当前在机器上存在的服务-主题对的一个列表。如果 \fIservice\fR  和 \fItopic\fR  都是空串({}),  则返回在系统上当前可获得的所有的服务-主题对。如果 \fIservice\fR 是空而 \fItopic\fR  不是，则返回指定主题的所有服务。如果 \fIservice\fR 不空而 \fItopic\fR  空，则返回指定服务的所有主题。如果均不空，若当前存在这个服务-主题对则返回它，否则返回空。                 
.TP
\fBdde eval \fItopic cmd \fR?\fIarg arg ...\fR?
\fBdde eval\fR   求值一个命令和它的参数，解释器用 \fItopic\fR 指定。DDE 服务必须是\fBTclEval\fR  服务。这个命令可以用于在 Windows 上替换 send。                 
.SH "DDE 和 TCL"
一个 Tcl 解释器总是有一个服务名 \fBTclEval\fR。每个不同的运行 Tcl 应用的解释器必须给予一个用 \fBdde servername\fR指定的唯一的名字。每个解释器只有使用 \fBdde servername\fR命令来设置名字，这个解释器才可作为一个 DDE 主题来获得。所以一个 \fBdde services TclEval {}\fR  命令将返回一个服务-主题对的列表，这里每个当前运行的解释器都将是一个主题。
.PP
当       
Tcl 处理一个 \fBdde execute\fR 命令时，用于执行的数据作为一个脚本在 \fBdde execute\fR 命令的主题指明的解释器中运行。
.PP
当 Tcl 处理一个 \fBdde request\fR命令时，它返回在 dde 命令中给出的变量的值，变量在由 dde主题指名的解释器的上下文中的。Tcl 为内部使用而保留变量 \fB$TCLEVAL  $EXECUTE $RESULT\fR，对这些变量的\fBdde request\fR  命令将返回不可预测的(unpredictable)结果。
.PP
打算运行一个Tcl 脚本的一个外部(external)应用应当使这个脚本在一个变量中存储它的结果，运行  \fBdde execute\fR  命令，接着运行 \fBdde request\fR 得到这个变量的值。
.PP
当使用 DDE 时，注意要确保使用 \fBupdate\fR或者 \fBvwait \fR来刷新事件队列。在使用\fBwish\fR时这是缺省的，但不包括调用了一个阻塞命令的情况(例如 \fBexec\fR  而不填加 \fB&amp;\fR  来在后台运行进程)。如果由于某种原因而导致事件队列没被刷新，DDE 命令将挂起(hang)直到事件队列被刷新。这可能产生死锁的情况。

.SH "参见 SEE ALSO"
tk(n), winfo(n), send(n)

.SH "关键字 KEYWORDS"
application, dde, name, remote execution
.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/06/18 
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
