'\"
'\" Copyright (c) 1996 Sun Microsystems, Inc.
'\" Copyright (c) 1998-1999 by Scriptics Corporation.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: @(#) $Id: socket.n,v 1.2 2003/11/24 05:10:00 bbbush Exp $
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: socket.n,v 1.2 2003/11/24 05:10:00 bbbush Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH socket n 8.0 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
socket \- 打开一个 TCP 网络连接
.SH "总览 SYNOPSIS"
.sp
\fBsocket \fR?\fIoptions\fR? \fIhost port\fR
.sp
\fBsocket\fR \fB\-server \fIcommand\fR ?\fIoptions\fR? \fIport\fR
.BE

.SH "描述 DESCRIPTION"
.PP
这个命令打开一个网络套接口并返回将来可被 \fBread\fR、\fBputs\fR 和 \fBflush \fR命令调用使用一个通道标识符。目前只支持 TCP 网络协议；将来的发行可能包括对补充协议的支持。依赖于是否指定了 \fB-server\fR 开关，可以使用 \fBsocket\fR 命令来打开客户端或服务器端连接。

.SH "客户端套接口 CLIENT SOCKETS"
.PP
如果未指定 \fB-server\fR 选项，则打开一个的连接的客户端并且命令返回一个可被用于读写的通道标识符。 \fIPort\fR 和 \fIhost\fR 指定一个要连接到的端口；必须有一个服务器接受在这个端口上的连接。\fIPort\fR 是一个整数端口号而 \fIhost\fR 要么是一个域名式样的名字如 \fBwww.sunlabs.com\fR 要么是一个数值 IP 地址如\fB127.0.0.1\fR。 使用 \fIlocalhost\fR 来参照在其上调用这个命令的那个主机。
.PP
在 \fIhost\fR 之前可以提供下列选项指定关于连接的补充信息:
.TP
\fB\-myaddr\fI addr\fR
\fIAddr\fR  给出用于连接的客户端网络接口的域名式样的名字或数值  IP 地址。如果客户端机器有多个网络接口的话这个选项会有用处。如果省略了这个选项，则由系统软件选择客户端接口。
.TP
\fB\-myport\fI port\fR
\fIPort\fR 指定用于连接的客户端的一个整数端口号。如果省略了这个选项，则由系统软件随机的选择客户端口号。
.TP
\fB\-async\fR
\fB\-async\fR 选项将导致客户端套接口被异步的连接。这意味着这个套接口将被立即建立，但在到\fBsocket\fR的调用返回的时候可能仍未连接到服务器上。在连接尝试成功或失败之前调用了   gets  或  flush 的时候，如果套接口在阻塞模式下，则将等待直到连接被完成或失败。如果套接口在非阻塞模式之下，而在连接尝试成功或失败之前调用了 gets 或 flush ，则操作立即返回，并且在套接口上的 \fBfblocked\fR 返回 1。

.SH "服务器套接口 SERVER SOCKETS"
.PP
如果指定了 \fB-server\fR 选项，则新套接口将是用 \fIport \fR给出的端口的一个服务器。Tcl 将自动接受到这个给定端口的连接。对于每个连接 Tcl 将建立可以用来同客户通信的一个新通道。Tcl 接着调用 \fIcommand\fR 并加上三个补充参数: 新通道的名字，用网络地址表示的客户的主机地址，和客户的端口号。
.PP
在 \fIhost\fR 之前可以提供下列选项指定关于连接的补充信息:
.TP
\fB\-myaddr\fI addr\fR
 \fIAddr\fR 给出用于连接的服务器端网络接口的域名式样的名字或数值  IP 地址。如果服务器机器有多个网络接口的话这个选项会有用处。如果省略了这个选项，则服务器套接口被绑定到特殊地址  INADDR_ANY 上，这样它可以接受来自任何接口的连接。
.PP
服务器通道不能被用来输入或输出；它们唯一的用处是接受新的客户连接。为每个到来的客户连接建立的通道是为输入和输出而打开的。关闭服务器通道将关断服务器，这样就不能接受新连接了，不影响现存的连接。
.PP
服务器套接口依赖于 Tcl 事件机制来找出何时打开了新连接。如果应用未进入事件循环，例如通过调用 \fBvwait\fR 命令或调用 C 过程 \fBTcl_DoOneEvent\fR，则不接受连接。

.SH "配置选项 CONFIGURATION OPTIONS"
可以使用 \fBfconfigure\fR 命令来查询套接口通道的许多只读配置选项:
.VS 8.0.5
.TP
\fB\-error\fR
这个选项得到给定套接口的当前错误状态。在你需要确定一个异步连接操作是否成功的时候这个选项会有用处。如果有一个错误，则返回错误消息。如果没有错误，则返回空串。
.VE 8.0.5
.TP
\fB\-sockname\fR
这个选项返回三个元素的一个列表，分别是这个套接口的地址、主机名和端口号。如果不能计算出这个主机名，第二个元素等同与列表的第一个元素地址。
.TP
\fB\-peername\fR
服务器套接口不支持这个选项。对于客户和接受的套接口，这个选项返回三个元素的一个列表；它们是地址、主机名字和对等的套接口所连接或绑定到端口。如果不能计算出这个主机名，第二个元素等同与列表的第一个元素地址。
.PP

.SH "参见 SEE ALSO"
flush(n), open(n), read(n)

.SH "关键字 KEYWORDS"
bind, channel, connection, domain name, host, network address, socket, tcp

.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/11/10
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
