// pwrmate.cpp
//
// Written and pasted together code snippets by Mike Studer AB6CV
// 2004-11-9
//
// INCLUDES
#include "pwrmate.h"
#include "findpowermate.h"

// DEFINES
#define BUFFER_SIZE 32 

using namespace std;


void pwrmate::powermate_pulse_led(int ps)
{
    findpowermate fpmt;
    fdp = fpmt.find_powermate(O_WRONLY);
  if(fdp < 0){
       QMessageBox::critical( 0, "Marote", "Unable to locate Powermate");
    return;
  }
  struct input_event ev;
  memset(&ev, 0, sizeof(struct input_event));  
  static_brightness = 0x80;
  pulse_speed = ps;
  pulse_table = 0;
  pulse_asleep = 0;
  pulse_awake = 1;
  ev.type = EV_MSC;
  ev.code = MSC_PULSELED;
  ev.value = static_brightness | (pulse_speed << 8) | (pulse_table << 17) | (pulse_asleep << 19) | (pulse_awake << 20);
  if(write(fdp, &ev, sizeof(struct input_event)) != sizeof(struct input_event))
      QMessageBox::critical( 0, "Marote", "Unable to write to Powermate");         
  close(fdp);    
  
}

void pwrmate::powermate_pulse_led_off()
{
    findpowermate fpmt;
    fdp = fpmt.find_powermate(O_WRONLY);
  if(fdp < 0){
       QMessageBox::critical( 0, "Marote", "Unable to locate Powermate");
    return;
  }
  struct input_event ev;
  memset(&ev, 0, sizeof(struct input_event));  
  static_brightness = 0x80;
  pulse_speed = 255;
  pulse_table = 0;
  pulse_asleep = 0;
  pulse_awake = 0;
  ev.type = EV_MSC;
  ev.code = MSC_PULSELED;
  ev.value = static_brightness | (pulse_speed << 8) | (pulse_table << 17) | (pulse_asleep << 19) | (pulse_awake << 20);
  if(write(fdp, &ev, sizeof(struct input_event)) != sizeof(struct input_event))
      QMessageBox::critical( 0, "Marote", "Unable to write to Powermate");         
  close(fdp);      
}

void pwrmate::process_event(struct input_event *ev)
{   
  switch(ev->type){
  case EV_MSC:
    //The LED pulse settings were changed; code=0x%04x, value=0x%08x\n", ev->code, ev->value
      // Who cares
    break;
  case EV_REL:
    if(ev->code == REL_DIAL)
      {
      emit dialed((int)ev->value);// + is up, - is down
    }
    break;
  case EV_KEY:
    if(ev->code == BTN_0)
  emit btnpress((int)ev->value); //Button was %s\n", ev->value? "pressed":"released"
    break;
  }
}

void pwrmate::run()
{
    // This is the thread that listens to events coming from the Powermate
    // It is a read only function   
    findpowermate fpmt;
    fdr = fpmt.find_powermate(O_RDONLY); // fdr is file descriptor
      if(fdr < 0){
       fprintf(stderr, "Unable to open Powermate");
       return;
   }
  struct input_event ibuffer[BUFFER_SIZE];
  int r, events, i;

  while(1){
    r = read(fdr, ibuffer, sizeof(struct input_event) * BUFFER_SIZE);
    if( r > 0 ){
      events = r / sizeof(struct input_event);
      for(i=0; i<events; i++)
 process_event(&ibuffer[i]);
    }else{
      //QMessageBox::warning( 0, "Marote", "read() failed");
 fprintf(stderr, "Powermate read failed");
      return;
    }
  }    
  
}


