/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: mas_endian.h,v 1.1.1.1 2003/01/22 13:26:17 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */

/* $XFree86: xc/programs/Xserver/include/misc.h,v 3.22 1999/08/21 13:48:44 dawes Exp $ */
/***********************************************************

Copyright 1987, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.


Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

Copyright 1992, 1993 Data General Corporation;
Copyright 1992, 1993 OMRON Corporation  

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that the
above copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation, and that
neither the name OMRON or DATA GENERAL be used in advertising or publicity
pertaining to distribution of the software without specific, written prior
permission of the party whose name is to be used.  Neither OMRON or 
DATA GENERAL make any representation about the suitability of this software
for any purpose.  It is provided "as is" without express or implied warranty.  

OMRON AND DATA GENERAL EACH DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
IN NO EVENT SHALL OMRON OR DATA GENERAL BE LIABLE FOR ANY SPECIAL, INDIRECT
OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
OF THIS SOFTWARE.

******************************************************************/

#ifndef _mas_endian_h_
#define _mas_endian_h_


#define MAS_LIL_ENDIAN_ORD 0xDCBA
#define MAS_BIG_ENDIAN_ORD 0xABCD

/* If the endianness isn't explicitly set, try the following to figure
   out what we might be */
#if (!defined(MAS_BIG_ENDIAN) && !defined(MAS_LITTLE_ENDIAN))

#if	defined(__i386__) || defined(__ia64__) || defined(WIN32) || \
	(defined(__alpha__) || defined(__alpha)) || \
	defined(__arm__) || \
	(defined(__mips__) && defined(__MIPSEL__)) || \
	defined(__LITTLE_ENDIAN__)
#define MAS_ENDIANESS	MAS_LIL_ENDIAN_ORD
#define MAS_LITTLE_ENDIAN
#else
#define MAS_ENDIANESS	MAS_BIG_ENDIAN_ORD
#define MAS_BIG_ENDIAN
#endif

#else /* The endianness is explicitly set */

#ifdef MAS_BIG_ENDIAN
#define MAS_ENDIANESS  MAS_BIG_ENDIAN_ORD
#else
#define MAS_ENDIANESS  MAS_LIL_ENDIAN_ORD
#endif 

#endif /* (!defined(MAS_BIG_ENDIAN) && !defined(MAS_LITTLE_ENDIAN)) */

/** Use faster system byte swapping functions if available */
#ifdef linux
#include <asm/byteorder.h>
#ifdef __arch__swab16
#define mas_swap16  __arch__swab16
#endif
#ifdef __arch__swab32
#define mas_swap32  __arch__swab32
#endif
#endif

/** otherwise, default to these local versions */
/* byte swap a 32-bit value */
#ifndef mas_swap32
#define mas_swap32(x) ((((x) & 0x000000ff) << 24)| \
		   (((x) & 0x0000ff00) << 8) | \
		   (((x) & 0x00ff0000) >> 8) | \
		   (((x) & 0xff000000) >> 24))
#endif

/* byte swap a 16 bit value */
#ifndef mas_swap16
#define mas_swap16(x) ((((x) & 0x00ff) << 8) | (((x) & 0xff00) >> 8))
#endif

/* Define host conversion routines */
#if MAS_ENDIANESS == MAS_BIG_ENDIAN_ORD
#define mas_betohl(x) (x)
#define mas_betohs(x) (x)
#define mas_ntohl(x)  (x)
#define mas_ntohs(x)  (x)
#define mas_htobel(x) (x)
#define mas_htobes(x) (x)
#define mas_htonl(x)  (x)
#define mas_htons(x)  (x)
#define mas_letohl(x) mas_swap32(x)
#define mas_letohs(x) mas_swap16(x)
#define mas_htolel(x) mas_swap32(x)
#define mas_htoles(x) mas_swap16(x)

#elif MAS_ENDIANESS == MAS_LIL_ENDIAN_ORD
#define mas_betohl(x) mas_swap32(x)
#define mas_betohs(x) mas_swap16(x)
#define mas_ntohl(x)  mas_swap32(x)
#define mas_ntohs(x)  mas_swap16(x)
#define mas_htobel(x) mas_swap32(x)
#define mas_htobes(x) mas_swap16(x)
#define mas_htonl(x)  mas_swap32(x)
#define mas_htons(x)  mas_swap16(x)
#define mas_letohl(x) x
#define mas_letohs(x) x
#define mas_htolel(x) x
#define mas_htoles(x) x

#endif /* MAS_ENDIANESS */



#endif /* _mas_endian_h_ */



