/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MAS_STATS_H
#define	_MAS_STATS_H

#include "mas_common.h"

#define MASC_STATS_MEAN         0x01
#define MASC_STATS_MINMAX       0x02
#define MASC_STATS_WIN_MEAN     0x04
#define MASC_STATS_WIN_ERROR    0x08
#define MASC_STATS_WIN_MINMAX   0x10
#define MASC_STATS_ALL          ( MASC_STATS_MEAN | MASC_STATS_MINMAX | MASC_STATS_WIN_MEAN | MASC_STATS_WIN_ERROR | MASC_STATS_WIN_MINMAX )

extern int32 masc_stats_init( struct mas_stats* s, int win_size, int compute_flags );
extern int32 masc_stats_update( struct mas_stats* s, double val );
extern void masc_stats_cleanup( struct mas_stats* s );
extern void masc_stats_reset( struct mas_stats* s, int reset_flags_bool );
extern int32 masc_stats_recompute_window( struct mas_stats* s );
extern int32 masc_stats_compute_win_mean( struct mas_stats* s );
extern int32 masc_stats_compute_win_error( struct mas_stats* s );
extern int32 masc_stats_compute_win_minmax( struct mas_stats* s );

#endif /* _MAS_STATS_H */

