/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: buffer.c,v 1.1.1.1 2003/01/22 13:26:22 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mas/mas_dpi.h"
#include "buffer.h"

int32
anx_make_buffer( struct anx_buffer** buffer_ptr, int bytes, int fill_line )
{
    struct anx_buffer* buffer;

    buffer = MAS_NEW( buffer );
    
    if ( ( buffer->contents = masc_rtalloc( bytes ) ) == 0)
	return mas_error(MERR_MEMORY);

    buffer->allocated_bytes = bytes;
    buffer->filling = TRUE;
    buffer->fill_line = fill_line;

    *buffer_ptr = buffer;
    
    return 0;
}

int32
anx_destroy_buffer( struct anx_buffer* buffer )
{
    if ( buffer->allocated_bytes && buffer->contents )
        masc_rtfree( buffer->contents );

    masc_rtfree( buffer );

    return 0;
}

int32
anx_reset_buffer( struct anx_buffer* buffer )
{
    buffer->filling = FALSE;
    buffer->pos = 0;
    buffer->head = 0;

    return 0;
}

int32
anx_buffer_append( struct anx_buffer* buffer, char* data, int size )
{
    if ( size == 0 )
        return mas_error( MERR_INVALID );
    
    if ( buffer->pos + size > buffer->allocated_bytes )
        return mas_error( MERR_XRUN );

    memcpy(&(buffer->contents[buffer->pos]), data, size);

    buffer->pos += size;

    if ( buffer->pos >= buffer->fill_line )
        buffer->filling = FALSE;

    return 0;
}

