/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/** THIS IS THE CLIENT-SIDE INCLUDE **/

#ifndef _mas_cdrom_common_h_
#define _mas_cdrom_common_h_

#include "mas/mas_common.h"

/* Status codes for the cd player */
#define CDROM_PLAY	1
#define CDROM_PAUSE	2
#define CDROM_RESUME	3
#define CDROM_STOP	4
#define CDROM_EJECT	5
#define CDROM_COMPLETE	6
#define CDROM_ERROR	7


/* Minutes, Seconds, Frame data */
struct track_msf
{
	int minute;
	int second;
	int frame;	/* There are 75 frames in a second */
};

struct track
{
	char			*trackname;		/* The track name */
	struct track_msf	start_msf;		/* The start of the track on the cd */
	struct track_msf	length_msf;		/* The length of the track */
};

typedef struct
{
	int			cddb_id;		/* ID generated from the cddb algorithm */
	char			*genre;			/* Genre of the cd */
	char			*title;			/* Title of the cd */
	char			*year;			/* Year of the cd */
	char			*misc_data;		/* Misc data from the cddb database. */
	int			number_of_tracks;	/* The number of tracks on the cd */
	struct track		*tracks;		/* Info for each track */
} CD_Information;

typedef struct
{
	char			*device_location;	/* String with the device name */
	int			status;			/* The status of the cd being played */
	int			current_track;		/* The current track being played */
	struct track_msf	absolute_msf;		/* Location on entire cd */
	struct track_msf	relative_msf;		/* Location on current track */
} CD_Status;



#endif /* _mas_cdrom_common_h_ */
