/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mas_api_internal.h"

int32
_alloc_device( mas_device_t* device )
{
    struct _mas_api_internal_device *handle;
    
    handle = MAS_NEW( handle );
    if( handle == NULL )
        return -1;
    
    *device = handle;
    
    return 0;
}

int32
_free_device( mas_device_t* device )
{
    struct _mas_api_internal_device *handle;
    
    handle = *device;
    _free_channel( &(handle->control_channel) );
    masc_rtfree( handle );

    return 0;
}

int32
_alloc_port( mas_port_t* port )
{
    struct _mas_api_internal_port *handle;
    
    handle = MAS_NEW( handle );
    if ( handle == 0 ) return mas_error( MERR_MEMORY );
    
    *(struct _mas_api_internal_port**)port = handle;
    
    return 0;
}

int32
_free_port( mas_port_t* port )
{
    struct _mas_api_internal_port *handle;
    
    handle = *port;
    _free_channel( &(handle->control_channel) );
    masc_rtfree( handle );

    return 0;
}

int32
_alloc_channel( mas_channel_t* channel )
{
    struct _mas_api_internal_channel *handle;
    
    handle = MAS_NEW( handle );
    if( handle == 0 ) return mas_error(MERR_MEMORY);
    
    *channel = handle;

    return 0;
}

int32
_free_channel( mas_channel_t* channel )
{
    struct _mas_api_internal_channel *handle;
    
    handle = *channel;
    masc_rtfree( handle->hostname );
    masc_rtfree( handle );

    return 0;
}

int32
_copy_channel( mas_channel_t channel_dest, mas_channel_t channel_src )
{
    struct _mas_api_internal_channel *handle_dest;
    struct _mas_api_internal_channel *handle_src;    

    handle_dest = channel_dest;
    handle_src = channel_src;

    handle_dest->id = handle_src->id;
    handle_dest->hostname = masc_rtalloc( strlen(handle_src->hostname) + 1 );
    strcpy( handle_dest->hostname, handle_src->hostname );

    return 0;
}

void
mas_free_device( mas_device_t device )
{
    _free_device( &device );
}

void
mas_free_port( mas_port_t port )
{
    _free_port( &port );
}

void
mas_free_channel( mas_channel_t channel )
{
    _free_channel( &channel );
}
