#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c)2003, Matthias A. Benkard.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import core.common
from core.parser import parse, Primitive, Sum, Difference, \
		Product, Quotient, Potence, Equation, Function, \
		SumChain, ProductChain #, Matrix

import unittest

class ParserTestCase(unittest.TestCase):
	def test_detection(self):
		# Primitives.
		self.assert_(parse("a").__class__ == Primitive)
		self.assert_(parse("B5").__class__ == Primitive)
		self.assert_(parse("100").__class__ == Primitive)
		self.assert_(parse("3.1415").__class__ == Primitive)
		self.assert_(parse("%PI").__class__ == Primitive)
		
		# Simple operations.
		self.assert_(parse("1 + 2").__class__ == Sum)
		self.assert_(parse("1 - 2").__class__ == Difference)
		self.assert_(parse("1 * 2").__class__ == Product)
		self.assert_(parse("1 / 2").__class__ == Quotient)
		self.assert_(parse("1 ^ 2").__class__ == Potence)
		self.assert_(parse("1 ** 2").__class__ == Potence)
		self.assert_(parse("4 ^ -2").__class__ == Potence)
		self.assert_(parse("sqrt(4)").__class__ == Potence)  # !
		
		self.assert_(parse("1^5 * 2 + 3 * 4").__class__ == Sum)
		self.assert_(parse("1 + 2 - 3").__class__ == SumChain)
		self.assert_(parse("(f(a + b + c) - 5 * 3 + (7*3)^5)").__class__ == SumChain)
		self.assert_(parse("5^4 - 3 * 4").__class__ == Difference)
		self.assert_(parse("1 / 2^6 * 3").__class__ == ProductChain)
		self.assert_(parse("(6 + 4)^4 / 5^3").__class__ == Quotient)
		self.assert_(parse("3^(4 * 5 - 3)").__class__ == Potence)
		
		# Functions.
		self.assert_(parse("sin(x)").__class__ == Function)
		
		# Simple composites and containers.
		self.assert_(type(parse("[a, b, c]")) == type([]))
		self.assert_(parse("(a + b)").__class__ == Sum)
		
		self.assert_(type(parse("[a + b * 3^5, b = c, 5^5 + b = sin(x^2)]")) == type([]))
		
		# Equations.
		self.assert_(parse("a = b").__class__ == Equation)
		self.assert_(parse("a*2 / sin(x) = b-3*y^5 * (x - z)").__class__ == Equation)


if __name__ == '__main__':
	core.common.init()
	unittest.main()

