// Tags: JDK1.2

// Copyright (C) 2005 Audrius Meskauskas (AudriusA@Bioinformatics.org)

// Mauve is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// Mauve is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with Mauve; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.  */


package gnu.testlet.org.omg.CORBA.ServiceInformationHelper;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

import gnu.testlet.org.omg.CORBA.Asserter;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ServiceDetail;
import org.omg.CORBA.ServiceInformation;
import org.omg.CORBA.ServiceInformationHelper;
import org.omg.CORBA.portable.OutputStream;

/**
 * This class tests the ServiceInformationHelper, but as important
 * side effect if also verifies the CORBA implementation part, used
 * by the numerous other Helpers.
 *
 * @author Audrius Meskauskas (AudriusA@bluewin.ch)
 */
public class basicHelperOperations
  extends Asserter implements Testlet
{
  private ORB orb;

  public void testCDR_Read_Write()
  {
    OutputStream out = orb.create_output_stream();
    ServiceInformationHelper.write(out, createInstance());

    ServiceInformation r =
      ServiceInformationHelper.read(out.create_input_stream());

    verifyInstance(r);
  }

  public void testHelper_Insert_Extract()
  {
    Any a = orb.create_any();
    ServiceInformationHelper.insert(a, createInstance());

    ServiceInformation extracted = ServiceInformationHelper.extract(a);

    verifyInstance(extracted);
  }

  /**
   * Test the support of the typical constructs, generated by some IDL
   * compilers to insert into Any/exctract from Any.
   */
  public void testAny_read_write()
  {
    Any a = orb.create_any();
    org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
    a.type(ServiceInformationHelper.type());
    ServiceInformationHelper.write(out, createInstance());
    a.read_value(out.create_input_stream(), ServiceInformationHelper.type());

    verifyInstance(ServiceInformationHelper.read(a.create_input_stream()));
  }

  /**
   * Verify the verifyer.
   */
  public void testSelf()
  {
    ServiceInformation s = createInstance();
    verifyInstance(s);
  }

  protected ServiceInformation createInstance()
  {
    ServiceInformation s = new ServiceInformation();

    s.service_options = new int[] { 9, 8, 7, 4, 5 };

    s.service_details =
      new ServiceDetail[]
      {
        new ServiceDetail(5, new byte[] { 1, 2, 3 }),
        new ServiceDetail(7, new byte[] { 9, 8, 7 })
      };

    return s;
  }

  protected void verifyInstance(ServiceInformation x)
  {
    ServiceInformation s = createInstance();

    assertEquals("service_options.length", s.service_options.length,
                 x.service_options.length
                );
    for (int i = 0; i < s.service_options.length; i++)
      {
        assertEquals("service_options[" + i + "]", s.service_options [ i ],
                     x.service_options [ i ]
                    );
      }

    assertEquals("service_details.length", s.service_details.length,
                 x.service_details.length
                );

    for (int k = 0; k < s.service_details.length; k++)
      {
        ServiceDetail e = s.service_details [ k ];
        ServiceDetail a = x.service_details [ k ];
        assertEquals("s_d[" + k + "].service_detail_type",
                     e.service_detail_type, a.service_detail_type
                    );
        assertEquals("s_d[" + k + "].length", e.service_detail.length,
                     a.service_detail.length
                    );
        for (int i = 0; i < e.service_detail.length; i++)
          {
            assertEquals("s_d[" + k + "].service_detail[" + i + "]",
                         e.service_detail [ i ], a.service_detail [ i ]
                        );
          }
      }
  }

  public void test(TestHarness harness) {
    h = harness;
    orb = ORB.init();
    testSelf();
    testCDR_Read_Write();
    testAny_read_write();
    testHelper_Insert_Extract();
  }
}
