/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __CHANNELITEM_H__
#define __CHANNELITEM_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <qlistview.h>
#include <qurloperator.h>
#include <qobject.h>
#include <qpixmap.h>
//-----------------------------------------------------------------------------------------------------------------------
#include "channel.h"
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget;
//-----------------------------------------------------------------------------------------------------------------------
class ChannelItem : public QObject, public QListViewItem
{
	Q_OBJECT
public:
	ChannelItem(MainWidget *parent, QListView *lv, Channel *channel);
	~ChannelItem() { if(m_uop) delete m_uop; }

	Channel* channel() { return(m_channel); }
	Channel* channel() const { return(m_channel); }
	void loadChannelLogo();
	void setEmptyIcon();

protected:
	virtual int compare(QListViewItem * with, int col, bool ascending) const;

public slots:
	void updateIcon(QNetworkOperation*);

private:
	MainWidget *m_parent;
	Channel *m_channel;
	QUrlOperator *m_uop;
	QPixmap m_icon;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
