/***************************************************************************
 *   Copyright (C) 2005-2006 by Robert Maxe                                *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __PARSEMASTER_H__
#define __PARSEMASTER_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <qptrlist.h>
#include <qstring.h>
#include <qdatetime.h>
#include "channel.h"
#include "program.h"
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget;
//-----------------------------------------------------------------------------------------------------------------------
class ParseMaster
{
public:
	enum ParseError { NONE, MEMORY, FILE, EMPTY };

	ParseMaster(MainWidget *parent);

	bool parse(QString file);
	QString errorMessage() { return(m_errorMsg); }
	ParseError error() { return(m_error); }
	int futureDates();
	QPtrList<Channel>* channels() { return(&m_channels); }
	QPtrList<Program>* programs() { return(&m_programs); }
	QStringList* categories() { return(&m_categories); }
	int wireChannels();
	void loadCustomizedChannels();
	void saveCustomizedChannels();

private:
	MainWidget *m_parent;
	QPtrList<Channel> m_channels;
	QPtrList<Program> m_programs;
	QStringList m_categories;
	QString m_errorMsg;
	ParseError m_error;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
