/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kmessagebox.h>

#include <klocale.h>
#include <kpopupmenu.h>
#include "favouritemaster.h"
#include "mainwidget.h"
#include "program.h"
#include "blistmaster.h"
#include "searchview.h"
//-----------------------------------------------------------------------------------------------------------------------
SearchView::SearchView(MainWidget *parent, ProgramMaster *programMaster, KListView *lv, QPtrList<Program> *programs, QWidget *frame)
	: BaseView(parent, programMaster, lv, programs, frame)
{
	m_lineEdit = m_parent->le_search;
	m_titles = m_parent->cb_searchtitles;
	m_actors = m_parent->cb_searchactors;
	m_desc = m_parent->cb_searchdesc;
	m_hits = m_parent->tl_hits;

	connect(m_lineEdit, SIGNAL(textChanged(const QString&)), this, SLOT(rebuild()));
	connect(m_titles, SIGNAL(toggled(bool)), this, SLOT(rebuild()));
	connect(m_actors, SIGNAL(toggled(bool)), this, SLOT(rebuild()));
	connect(m_desc, SIGNAL(toggled(bool)), this, SLOT(rebuild()));
}
//-----------------------------------------------------------------------------------------------------------------------
//void SearchView::loadSettings(KConfig *cfg) { }
//-----------------------------------------------------------------------------------------------------------------------
//void SearchView::saveSettings(KConfig *cfg) { }
//-----------------------------------------------------------------------------------------------------------------------
bool SearchView::rebuild()
{
	QDate today(QDate::currentDate());
	Program *program;
	QString start, text = m_lineEdit->text();
	int daysTo, hits = 0;

	saveSelection();
	m_lv->clear();
	m_hits->setText("0");
	updateDesc();
	if(m_lineEdit->text().isEmpty() || m_lineEdit->text().length() < 2)
		return(true);

	for(uint i=0; i<m_programs->count(); i++) {
		program = m_programs->at(i);
		if((m_titles->isChecked() && program->title().contains(text, false)) || (m_actors->isChecked() && program->actors().contains(text, false)) || (m_desc->isChecked() && program->desc().contains(text, false))) {
			daysTo = today.daysTo(program->startDT().date());
			if(daysTo == 0) {
				start = program->startDT().toString("hh:mm");
			} else {
				start = program->startDT().toString("hh:mm  ddd");
				if(daysTo > 0)
					start += ("  (+" + QString::number(daysTo) + ") ");
				else
					start += ("  (" + QString::number(daysTo) + ") ");
			}
			new ProgramItem(m_parent, m_lv, program, start, program->title(), program->duration().toString("h:mm"), program->channel()->customName());
			hits++;
		}
	}
	m_hits->setText(QString::number(hits));
	m_lv->sort();
	if(!refresh())
		return(false);
	restoreSelection();
	updateDesc();
	return(true);
}
//-----------------------------------------------------------------------------------------------------------------------
void SearchView::showPopupMenu(KListView*, QListViewItem *item, const QPoint&)
{
	KPopupMenu *searchMenu = new KPopupMenu(m_parent);
	FavouriteMaster *favouriteMaster = m_parent->favouriteMaster();
	BlistMaster *blistMaster = m_parent->blistMaster();
	Program *program = NULL;

	if(item) program = ((ProgramItem*)item)->program();

	if(program && favouriteMaster->isFavourite(program->title())) {
		searchMenu->insertItem(i18n("Remove from Favourites"), favouriteMaster, SLOT(removeFavourite()), Key_Space);
	} else {
		int a = searchMenu->insertItem(i18n("Add to Favourites"), favouriteMaster, SLOT(addFavourite()), Key_Space);
		searchMenu->setItemEnabled(a, (item?true:false));
	}
	searchMenu->insertSeparator();
	int b = searchMenu->insertItem(i18n("Blacklist"), blistMaster, SLOT(addBlacklist()), CTRL+Key_B);
	searchMenu->setItemEnabled(b, (item?true:false));
	searchMenu->insertSeparator();
	
	searchMenu->setCheckable(true);
	int h = searchMenu->insertItem(i18n("Hide Past"), this, SLOT(toggleHidePast()), CTRL+Key_H);
	searchMenu->setItemChecked(h, m_hidePast);
	searchMenu->insertSeparator();
	searchMenu->insertItem(i18n("Day View..."), m_parent, SLOT(setView(int)), Key_F1, 0);
	searchMenu->insertItem(i18n("Full View..."), m_parent, SLOT(setView(int)), Key_F2, 2);
	int s = searchMenu->insertItem(i18n("Search View..."), m_parent, SLOT(setView(int)), Key_F3, 1);
	searchMenu->setItemEnabled(s, false);
	searchMenu->insertSeparator();
	int fo = searchMenu->insertItem(i18n("Forum..."), m_parent, SLOT(setView(int)), Key_F4, 3);
	searchMenu->setItemEnabled(fo, (item?true:false));

	searchMenu->exec(QCursor::pos());

	delete searchMenu;
}
//-----------------------------------------------------------------------------------------------------------------------
void SearchView::aboutToShow()
{
	updateDesc();
	if(!refresh())
		rebuild();
}
//-----------------------------------------------------------------------------------------------------------------------
