""" Renames the selected resources. """


# Standard library imports.
import sys

# Enthought library imports.
from enthought.envisage.ui import SelectionListenerAction
from enthought.pyface.api import GUI, error


class RenameAction(SelectionListenerAction):
    """ Renames the selected resources. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event):
        """ Performs the action. """                

        # fixme: In terms of the whole UI model thang... This method would be a
        # method on the project UI service, and '_copy_nodes' would be a method
        # on the project service?!?  The scripting layer can then expose both
        # methods...
        selection = self.window.selection
        
        try:
            self._rename_nodes(selection, event.widget)

        except:
            type, value, traceback = sys.exc_info()
            error(self.window.control, "Rename failed\n%s" % str(value))
            
        return

    ###########################################################################
    # 'SelectionListenerAction' interface.
    ###########################################################################

    def refresh(self):
        """ Refresh the enabled/disabled state of the action. """

        if self.window is not None and len(self.window.selection) > 0:
            for node in self.window.selection:
                # Get the resource type of the node that we are renaming.
                resource_type = self.resource_manager.get_type_of(node.obj)

                # Can the node be copied?
                if not resource_type.node_type.is_editable(node):
                    self.enabled = False
                    break

            else:
                self.enabled = True

        else:
            self.enabled = False

        return

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _rename_nodes(self, nodes, widget):
        """ Renames a list of nodes. """

        # We only rename ONE node at a time (a la Windows).  In this case
        # we abitrarily pick the first on in the selection.
        node = nodes[0]
        
        # Start a label edit.
        GUI.invoke_later(widget.edit_label, *(node,))
        
        return
    
#### EOF ######################################################################
