""" A wizard for creating a new file resource. """


# Standard library imports.
from os.path import join

# Enthought library imports.
from enthought.io import File
from enthought.traits.api import Instance

# Local imports.
from new_named_resource_page import NewNamedResourcePage
from new_resource_wizard import NewResourceWizard
from resource_factory import ResourceFactory


class FileFactory(ResourceFactory):
    """ A factory that creates file resources. """
    
    ###########################################################################
    # 'ResourceFactory' interface.
    ###########################################################################

    def create_resource(self):
        """ Creates the resource. """

        # Create a new (and empty) file.
        f = File(join(self.parent_folder.obj.path, self.name))
        
        self.parent_folder.obj.bind(self.name, f)
        
        return f


class NewFileWizard(NewResourceWizard):
    """ A wizard for creating a new file resource. """

    #### 'Window' interface ###################################################

    # The window title.
    title = 'New File'

    #### 'NewResourceWizard' interface ########################################

    # The resource factory that the wizard is configuring.
    factory = Instance(FileFactory, ())
    
    ###########################################################################
    # 'NewResourceWizard' interface.
    ###########################################################################

    def reset(self):
        """ Reset the wizard to the initial state. """
        
        # This wizard contains a single page that allows the user to select the
        # folder in which to create the resource, and to give the new resource
        # a name.
        self.pages = [
            NewNamedResourcePage(
                text   = 'Select the parent folder',
                prefix = 'New File',
                obj    = self.factory
            )
        ]

        return
    
#### EOF ######################################################################
