""" A wizard for creating new folder resources. """


# Enthought library imports.
from enthought.traits.api import Instance

# Local imports.
from new_named_resource_page import NewNamedResourcePage
from new_resource_wizard import NewResourceWizard
from resource_factory import ResourceFactory


class FolderFactory(ResourceFactory):
    """ A factory that creates folder resources. """
    
    ###########################################################################
    # 'ResourceFactory' interface.
    ###########################################################################

    def create_resource(self):
        """ Creates the resource. """

        # Create a new (and empty) folder.
        self.parent_folder.obj.create_subcontext(self.name)
        
        return


class NewFolderWizard(NewResourceWizard):
    """ A wizard for creating new folder resources. """

    #### 'Window' interface ###################################################

    # The window title.
    title = 'New Folder'

    #### 'NewResourceWizard' interface ########################################
    
    # The resource factory that the wizard is configuring.
    factory = Instance(FolderFactory, ())
    
    ###########################################################################
    # 'NewResourceWizard' interface.
    ###########################################################################

    def reset(self):
        """ Reset the wizard to the initial state. """

        # This wizard contains a single page that allows the user to select the
        # folder in which to create the resource, and to give the new resource
        # a name.
        self.pages = [
            NewNamedResourcePage(
                text   = 'Select the parent folder',
                prefix = 'New Folder',
                obj    = self.factory
            )
        ]

        return
        
#### EOF ######################################################################
