""" The node type for file resources. """


# Enthought library imports.
from enthought.pyface.api import ImageResource

# Local imports.
from resource_node_type import ResourceNodeType


class FileNodeType(ResourceNodeType):
    """ The node type for file resources. """

    #### 'NodeType' interface #################################################

    # The image used to represent nodes of this type.
    image = ImageResource('file')

    ###########################################################################
    # 'NodeType' interface.
    ###########################################################################

    #### Content ####
    
    def allows_children(self, node):
        """ Does the node allow children (ie. a folder vs a file). """

        return False

    #### Copy/Cut/Delete/Paste ####

    def can_copy(self, node):
        """ Can a node be copied? """

        return True

    def can_cut(self, node):
        """ Can a node be cut? """

        return False

    def can_delete(self, node):
        """ Can a node be deleted? """

        return False
    
    def can_paste(self, node, data):
        """ Can an object be pasted onto a node? """

        return False
    
#### EOF ######################################################################
