""" The node type for Python lists. """


# Enthought library imports.
from enthought.envisage.resource import ObjectNodeType
from enthought.pyface.api import ImageResource
from enthought.traits.api import Str

# Local imports.
from list_node_monitor import ListNodeMonitor


class ListNodeType(ObjectNodeType):
    """ The node type for Python lists. """

    #### 'NodeType' interface #################################################

    # The image used to represent nodes of this type that are NOT expanded.
    closed_image = ImageResource('list')

    # The image used to represent nodes of this type that ARE expanded.
    open_image = closed_image

    #### 'ListNodeType' interface #############################################

    # The name of the trait that contains the list!
    list_trait = Str

    # The name of the trait on the *items* of the list that contains the 'name'
    # used in creating bindings etc.
    item_name_trait = Str('name')

    ###########################################################################
    # 'NodeType' interface.
    ###########################################################################

    def get_monitor(self, node):
        """ Returns a monitor that detects changes to a node.

        Returns None by default, which indicates that the node is not
        monitored.

        """

        monitor = ListNodeMonitor(
            node            = node,
            list_trait      = self.list_trait,
            item_name_trait = self.item_name_trait
        )

        return monitor
    
#### EOF ######################################################################
