""" A proxy for a preference node created from a bundle. """


# Enthought library imports.
from enthought.envisage import get_application
from enthought.pyface.preference.api import PreferenceNode, PreferencePage
from enthought.traits.api import Str


class WorkbenchPreferenceNode(PreferenceNode):
    """ A proxy for a preference node created from a bundle. """

    # The name of the node's preference page implementation class.
    class_name = Str

    # The ID of the help topic for the node's preference page
    help_id = Str

    ###########################################################################
    # 'PreferenceNode' interface.
    ###########################################################################

    def create_page(self):
        """ Creates the preference page for this node. """

        # Import the class that implements the preference page for this node.
        # The class should support the 'PreferencePage' interface.
        klass = get_application().import_manager.import_symbol(self.class_name)
        if not issubclass(klass, PreferencePage):
            raise TypeError("Page must be derived from 'PreferencePage'")

        return klass(help_id=self.help_id)

#### EOF ######################################################################
