""" A window in the workarea with content comprised of a single traits ui.

This is a convenience class for viewing HasTraits objects in Envisage using
their default editor.
"""

# Enthought library imports.
from enthought.traits.api import HasTraits, Instance

# Local imports.
from workarea_window import WorkareaWindow


class TraitsWorkareaWindow(WorkareaWindow):
    """ A window in the workarea with content comprised of a single traits ui.
    """

    # The object whose traits ui appears in this window.
    object = Instance(HasTraits)
    
    # TODO: Add some traits which specify how the button bar should look.

    ###########################################################################
    # 'object' interface
    ###########################################################################

    def __init__(self, object, **traits):
        """ Construct a new TraitsWorkareaWindow. """

        super(TraitsWorkareaWindow, self).__init__(**traits)

        self.object = object

        return

    ###########################################################################
    # Protected 'Window' interface.
    ###########################################################################

    def _create_contents(self, parent):
        """ Create the window contents. """

        panel = self.object.edit_traits(kind='panel', parent=parent)
        
        return panel.control

    def _size_control(self, control, content):
        """ Set the size of the toolkit specific control. """
        
        if content is not None and hasattr(content, 'GetSize'):
            # Size the content to the minimum of the available content area
            # or the size of the content -- independently in each direction.
            workbench_window = self.workbench_window
            client_window = workbench_window.control.GetClientWindow()
            client_width, client_height = client_window.GetSize()
            content_width, content_height = content.GetSize()

            size = ( min(client_width, content_width),
                     min(client_height, content_height) )

            control.SetClientSize(size)

        else:
            super(TraitsWorkareaWindow, self)._size_control(control)

        return


         
#### EOF ######################################################################
