""" Application branding information. """


# Enthought library imports.
from enthought.pyface.api import ImageResource
from enthought.traits.api import HasTraits, Instance, List, Str


class Branding(HasTraits):
    """ Application branding imformation. """

    ### 'Branding' interface #################################################

    # Additional text to display in the about box.
    about_additions = List(Str)

    # The about box image.
    about_image = Instance(ImageResource, ImageResource('about'))

    # The application icon.
    application_icon = Instance(ImageResource,ImageResource('application.ico'))

    # The application name (used for window titles etc).
    application_name = Str('Workbench')


### EOF ######################################################################

