""" A runnable that opens the first workbench window. """


# Enthought library imports.
from enthought.envisage.api import Runnable

# Local imports.
from services import IWORKBENCH


class WorkbenchRunnable(Runnable):
    """ A runnable that opens the first workbench window. """

    ###########################################################################
    # 'Runnable' interface.
    ###########################################################################

    def run(self, application):
        """ Runs the runnable!

        This creates and opens the first workbench window.

        """

        # This guard is an attempt to allow applications to run 'headless'
        # simply by not setting the application GUI (either explicitly, or via
        # the 'requires_gui' trait).
        if application.gui is not None:
            workbench = application.get_service(IWORKBENCH)
            
            # Create and open the first workbench window.
            window = workbench.create_window()
            window.open()

        return

#### EOF ######################################################################
