#include <med.h>
#include <med_config.h>
#include <med_outils.h>

/*
 * - Nom de la fonction : MEDnChampRef
 * - Description : Renvoi le nbre de maillages associs au champ ( <cha>/<type_ent>[.<type_geo>]/<numdtt>.<numoo> )
 * - Parametres :
 *     - fid        (IN) : ID du fichier HDF courant
 *     - cha        (IN) : le nom du champ 
 *     - type_ent   (IN) : entit du champ concerne  {MED_NOEUD,MED_ARETE,MED_FACE,MED_MAILLE}
 *      - type_geo  (IN) : type gomtrique de l'entit concern {MED_POINT,MED_SEG2 ......}
 *       - numdt    (IN) : n du pas de temps (MED_NOPDT si aucun)
 *       - numo     (IN) : n d'ordre utilis (MED_NONOR si aucun)
 * - Resultat : 0 en cas de succes, -1 sinon
 */ 


med_int MEDnChampRef(med_idt fid, char * cha, med_entite_maillage type_ent, 
		     med_geometrie_element type_geo,
		     med_int numdt, med_int numo)

{
  char chemin[(MED_TAILLE_CHA+MED_TAILLE_NOM+1)+(2*MED_TAILLE_NOM_ENTITE+2)+2*MED_MAX_PARA+1];
  int n1;
  char nomdatagroup1[2*MED_TAILLE_NOM_ENTITE+2];
  char nomdatagroup2[2*MED_MAX_PARA+1];
  char tmp1         [MED_TAILLE_NOM_ENTITE+1];

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /*
   * On construit le chemin d'accs de niveau 0
   */
  strcpy(chemin,MED_CHA);
  strcat(chemin,cha);
  strcat(chemin,"/");

  /* 
   * On construit le nom du datagroup de niveau 1 <type_ent>[.<type_geo>] n'existe pas => erreur
   */
  if ( _MEDnomEntite(nomdatagroup1,type_ent ) < 0) {
    MESSAGE("L'entit demande n'est pas une entit <med_entite_maillage> : ");
    SSCRUTE(chemin); ISCRUTE(type_ent); return -1;
  };

  if ((type_ent != MED_NOEUD))
    {
      if ( _MEDnomGeometrie(tmp1,type_geo) < 0) {
	MESSAGE("Le type gomtrique demand n'est pas un <med_geometrie_element> : ");
	SSCRUTE(chemin); ISCRUTE(type_geo); return -1;
      };
      strcat(nomdatagroup1,".");
      strcat(nomdatagroup1,tmp1);
    }
  strcat(chemin,nomdatagroup1);
  strcat(chemin,"/");

  
  /*
   *  On construit le nom du datagroup de niveau 2 <numdtt>.<numoo> n'existe pas => erreur
   */

  sprintf(nomdatagroup2,"%*li%*li",MED_MAX_PARA,(long ) numdt,MED_MAX_PARA,(long ) numo);
  strcat(chemin,nomdatagroup2);
  
  n1 = 0;
  if ( _MEDnObjets(fid,chemin,&n1) < 0 ) {
    MESSAGE("Impossible d'itrer dans le groupe : ");
    SSCRUTE(chemin); return -1;
  };

  return (med_int) n1;

}
