/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test14.c
 *
 * - Description : ecriture des noeuds d'un maillage MED
 *                 a l'aide des routines de niveau 2
 *                 equivalent a test4.c
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>
#include <string.h>

int main (int argc, char **argv)
{
  med_idt fid;
  /* la dimension du maillage */
  med_int mdim = 2;
  /* nom du maillage de longueur maxi MED_TAILLE_NOM */
  char maa[MED_TAILLE_NOM+1] = "maa1";
  /* le nombre de noeuds */
  med_int nnoe = 4;
  /* table des coordonnees  
     profil : (dimension * nombre de noeuds) */
  med_float coo[8] = {0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0};
  /* tables des noms et des unites des coordonnees 
     profil : (dimension*MED_TAILLE_PNOM+1) */
  /*                                  12345678901234561234567890123456 */
  char nomcoo[2*MED_TAILLE_PNOM+1] = "x               y               ";
  char unicoo[2*MED_TAILLE_PNOM+1] = "cm              cm              ";
  /* tables des noms, numeros, numeros de familles des noeuds
     autant d'elements que de noeuds - les noms ont pout longueur
     MED_TAILLE_PNOM */
  /*                                  1234567890123456123456789012345612345678901234561234567890123456 */
  char nomnoe[4*MED_TAILLE_PNOM+1] = "nom1            nom2            nom3            nom4";
  med_int numnoe[4] = {1,2,3,4};
  med_int nufano[4] = {0,1,2,2};; 

  /* Creation du fichier test14.med */
  if ((fid = MEDouvrir("test14.med",MED_CREATION)) < 0) {
    MESSAGE("Erreur a la creation du fichier test14.med");
    return -1;
  }
  
  /* Creation du maillage */
  if (MEDmaaCr(fid,maa,mdim,MED_NON_STRUCTURE,"Un maillage pour test14") < 0) {
    MESSAGE("Erreur a la creation du maillage");
    SSCRUTE(maa)
    return -1;
  }
  
  /* Ecriture des noeuds d'un maillage MED : 
     - Des cooordonnees en mode MED_FULL_INTERLACE : (X1,Y1,X2,Y2,X3,Y3,...) 
     dans un repere cartesien 
     - Des noms (optionnel dans un fichier MED) 
     - Des numeros (optionnel dans un fichier MED) 
     - Des numeros de familles des noeuds */	      
  if (MEDnoeudsEcr(fid,maa,mdim,coo,MED_FULL_INTERLACE,MED_CART,
		   nomcoo,unicoo,nomnoe,MED_VRAI,numnoe,MED_VRAI,
		   nufano,nnoe) < 0) {
    MESSAGE("Erreur a l'ecriture des noeuds du maillage");
    return -1;
  }

  /* Fermeture du fichier */
  if (MEDfermer(fid) < 0) {
    MESSAGE("Erreur a la fermeture du fichier");
    return -1;
  }
  
  return 0;
}




