/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: cli.h,v 1.6 2000/08/14 00:36:50 kos Exp $
 *
 */

#ifndef _CLI_H
#define _CLI_H

#include "array.h"

#define CLI_LINELEN 1024
#define CLI_MAXARGS 16

#define CLI_PARSE 1
#define CLI_RAW 2
#define CLI_DEFAULT 3
#define CLI_EXIT 4

#define CLI_PROMPT 1
#define CLI_PARSESEP 2

#define CLI_CMD_CHUNK 32
#define CLI_DEF_PROMPT "cli> "
#define CLI_DEF_PARSESEP " "

typedef int (*cmd_proc)(void *, int, char **);

typedef struct cmd_t {
  int type;
  char name[CLI_LINELEN];
  char help[CLI_LINELEN];
  cmd_proc proc;
  int argmin;
  int argmax;
  int match;
} cmd_t;

typedef struct cli_t {
  char prompt[CLI_LINELEN];
  char parsesep[CLI_LINELEN];
  char lastcommand[CLI_LINELEN];
  array *cmds;
  void *up;
} cli_t;

cli_t *cli_init(void *);
int cli_destroy(cli_t *);
int cli_register(cli_t *, int, cmd_proc, char *, ...);
int cli_set(cli_t *, int, ...);
int cli_main(cli_t *);

#endif /* _CLI_H */
