/***************************************************************************\
	mined text editor main include file
\***************************************************************************/

#undef __

#ifdef __STDC__
#define DEFPROTO
#endif

#ifdef NOPROTO
#undef DEFPROTO
#endif

#ifdef DEFPROTO
#define _(x) x
#else
#define _(x) ()
#endif


/***************************************************************************\
	system environment configuration
\***************************************************************************/

/* MSDOS basic configuration */
#ifdef __MSDOS__

#undef unix	/* needed for djgcc? */
#define msdos
#define pc

# ifndef __TURBOC__
# define __GCC__

#  ifdef __strange__
#  undef msdos	/* in this weird case, a more specific distinction */
#  define unix	/* has to be made everywhere according to the 'pc' flag */
#  endif
# endif
#endif


/* character set definition for visual indications */
#ifdef pc
#define pc_charset
#ifdef __CYGWIN__	/* from some version mid 2000 */
#undef pc_charset
#endif
#endif


/* MSDOS includes and declarations */
#ifdef msdos
extern void delay ();
extern void exit ();

#include <string.h>
#include <io.h>		/* this is not "io.h" */
#  include <stdio.h>
#  undef putchar
#  include <fcntl.h>
#  define FUNcmd	'\000'

# ifdef __TURBOC__
/* #define conio doesn't work with combined positioning/output method */
extern far * getenv ();
extern far * getcwd ();
extern void setdisk ();
extern void sleep ();
# else
#define conio
extern char * getenv ();
extern char * getcwd ();
# endif

#endif

#ifdef __TURBOC__
#define conio
#endif

#ifdef conio
#define dosmouse
#endif


/* VMS includes and declarations */
#ifdef vms
#  include <unixio.h>
#  include <file.h>	/* for the O_... attributes to open () */
#  include <unixlib.h>
#  undef putchar
#  undef FALSE
#  undef TRUE
#  define CURSES
#  define FUNcmd	'\000'
#endif


/* Unix and terminal I/O defines */
#ifdef TERMIO
#ifndef sysV
# define sysV
#endif
#endif

#ifdef sysV
#ifndef unix
# define unix
#endif
/* # define TERMIO ? */
#endif


/* Unix includes and defines */
#ifdef unix

/*#include <stdlib.h> */
#  include <stdio.h>
#  include <string.h>
/*#include <strings.h> ? */
#  include <fcntl.h>
#  include <unistd.h>
#  undef putchar
#  undef NULL
#  undef EOF
#  define FUNcmd	'\000'

#  ifdef sysV
   extern char * getcwd ();
#  else
   extern char * getwd ();
#  define getcwd(dirbuf, buflen)	getwd (dirbuf)
#  endif

extern void exit ();
extern char * getenv ();
/*extern int printf ();*/

#ifdef DEFVFORK
/* already declared in <unistd.h> */
#ifdef __STDC__
extern pid_t vfork ();
#else
#ifdef _CLASSIC_ID_TYPES
/* is this a HP special? */
extern int vfork();
#else
extern pid_t vfork ();
#endif
#endif
#endif

#ifdef __CYGWIN__
extern int vfork();
#endif

#ifdef __GCC__
extern int wait ();
#else
extern pid_t wait ();
#endif

extern int select ();
extern unsigned int sleep ();

#ifdef use_usleep
extern unsigned int usleep ();
#endif

#endif /* unix */


/* PC-specific defines */
#ifdef __CYGWIN__
#define __pcgcc__
#endif
#ifdef __MSDOS__
#define __pcgcc__
#endif
#ifdef __pcgcc__
#define PROT int
#else
#define PROT unsigned int
#endif


/* CJK tables mode */
#ifndef msdos
#define use_cjk_tables
#define use_keymap_tables
#endif


/***************************************************************************\
	declaration of types and constants
\***************************************************************************/

#define arrlen(arr)	(sizeof (arr) / sizeof (* arr))

typedef unsigned char character;
/*typedef unsigned int character;*/

/* Screen size and display definitions. Coordinates start at 0, 0 */
#ifdef pc
#  define maxYMAX		64
#  define maxXMAX		132
#else
#  define maxYMAX		126	/* 73 */
#  define maxXMAX		279	/* 163 */
#endif

extern int YMAX;
extern int XMAX;
extern short MENU;
#define SCREENMAX	(YMAX - 1)	/* last line displayed (first is 0) */
#define XBREAK		(XMAX - scrollbar_width)	/* Shift line display at this column */
extern int scrollbar_width;
#define XBREAK_bottom	(XMAX - 1)
#define SHIFT_SIZE	(tab8 (XMAX / 4 + 1))	/* Number of chars to shift */
#define maxLINE_LEN	(maxXMAX + 1)	/* max screen line length */
#define screen_BUFL	((((maxXMAX * maxYMAX) >> 10) + 1) << 10)
					/* Size of I/O buffering */

#define MAX_CHARS	1024		/* max chars on one line of text */
		/* LINE_START must be rounded up to the lowest SHIFT_SIZE */
#define LINE_START	(((-MAX_CHARS - 1) / SHIFT_SIZE) * SHIFT_SIZE \
  				   - SHIFT_SIZE)
#define LINE_END	(MAX_CHARS * 8)	/* Must be larger than highest 
					x-coordinate for line; MAX_CHARS + 1
					is not sufficient due to TABs */

/* Return values of functions */
#define ERRORS		-1
#define NO_LINE		(ERRORS - 1)	/* Must be < 0 */
#define NUL_LINE	(ERRORS - 2)	/* Must be < 0 */
#define SPLIT_LINE	(ERRORS - 3)	/* Must be < 0 */
#define FINE		0
#define NO_INPUT	(FINE + 1)

#define STD_IN		0		/* Input file # */
#define STD_OUT	 	1		/* Terminal output file # */
#define STD_ERR		2

#define REPORT_CHANGED_LINES	1	/* Report change of lines on # lines */

#ifndef pc
#ifndef O_BINARY
#define O_BINARY 0
#endif
#endif

/*
 * mouse button selection
 */
typedef enum {
	releasebutton,
	leftbutton,
	middlebutton,
	rightbutton,
	movebutton,
	wheelup,
	wheeldown
} mousebutton;

#define shift_button	4
#define meta_button	8
#define control_button	16

/*
 * Common enum type for all flags used in mined.
 */
typedef enum {
/* General flags */
  False,
  True,
  OFF,
  ON,

/* yank_status and other */
  NOT_VALID,
  VALID,

/* Expression flags */
  FORWARD,
  REVERSE,

/* Yank flags */
  SMALLER,
  BIGGER,
  SAME,
  NO_DELETE,
  DELETE,
  READ,
  WRITE,

/* smart quotes state */
  UNSURE,
  OPEN,
} FLAG;

/*
	line end definitions
 */
typedef unsigned char lineend_type;
#define lineend_NUL '\0'
#define lineend_NONE ' '
#define lineend_LF '\n'
#define lineend_CRLF '\r'
#define lineend_CR 'R'
#define lineend_LS 'L'	/* Unicode line separator 2028:   */
#define lineend_PS 'P'	/* Unicode paragraph separator 2029:   */

/*
 * The Line structure. Each line entry contains a pointer to the next line,
 * a pointer to the previous line, a pointer to the text and an unsigned char
 * telling at which offset of the line printing should start (usually 0).
 */
struct Line {
  struct Line * next;
  struct Line * prev;
  char * text;
  unsigned short shift_count;
  lineend_type return_type;
  char syntax_marker;	/* bitmask composed of values below */
};
#define syntax_none	0
#define syntax_HTML	1
#define syntax_JSP	2
#define syntax_comment	4

typedef struct Line LINE;

/* Dummy line indicator */
#define DUMMY		0x80
#define DUMMY_MASK	0x7F

/*
 * For casting functions with int/void results
 */
typedef void (* voidfunc) ();
typedef void (* signalfunc) ();	/* (int) */
typedef unsigned long (* charfunc) ();
typedef int (* intfunc) ();
typedef int (* flagfunc) ();	/* (menuitemtype *, int) */

/* NULL definitions */
#define NIL_PTR		((char *) 0)
#define NIL_LINE	((LINE *) 0)


/***************************************************************************\
	declaration of system functions
\***************************************************************************/

#ifdef define_read_write	/* don't define to be compatible */
extern int write ();
extern int read ();
extern ssize_t write ();	/* but how do I find out if */
extern ssize_t read ();		/* ssize_t is defined on a system? */
#endif
extern int access ();
/*extern int open ();*/
extern int close ();
/*extern int creat ();*/
extern int chdir ();
extern int system ();
extern int isatty ();
#ifndef strcmp
extern int strcmp ();
#endif


/***************************************************************************\
	variable declarations
\***************************************************************************/

extern int total_lines;		/* Number of lines in file */
extern long total_chars;	/* Number of characters in file */
extern LINE * header;		/* Head of line list */
extern LINE * tail;		/* Last line in line list */
extern LINE * top_line;		/* First line of screen */
extern LINE * bot_line;		/* Last line of screen */
extern LINE * cur_line;		/* Current line in use */
extern char * cur_text;		/* Pointer to char on current line in use */
extern int last_y;		/* Last y of screen, usually SCREENMAX */
extern int line_number;		/* current line # determined by file_status */
extern int lines_per_page;	/* assumption for file_status */

extern int x, y;		/* x, y coordinates on screen */
extern FLAG modified;		/* Set when file is modified */
extern FLAG viewonly;		/* Set when view only mode is selected */
extern FLAG restricted;		/* Set when restricted mode is selected */
extern FLAG mined_keypad;	/* Apply mined keypad assignments */
extern FLAG mined_del_is_cut;	/* Del key cuts buffer */
extern FLAG quit;		/* Set when quit character is typed */
extern FLAG intr_char;		/* Set when intr character is typed */
extern FLAG winchg;		/* Set when the window size changes */
extern FLAG interrupted;	/* Set when a signal interrupts */
extern FLAG waitingforinput;	/* Set while waiting for the next command key */
extern FLAG isscreenmode;	/* Set when screen mode is on */
extern unsigned int out_count;	/* Index in output buffer */
extern char text_buffer [MAX_CHARS];	/* Buffer for modifying text */
extern int input_fd;		/* File descriptors for terminal dialog */
extern int output_fd;
extern PROT fprot;		/* To be used for file creatings */
extern PROT bufprot;		/* To be used for paste buffer file */

#ifdef unix
extern char * window_string_code;
extern char window_string [];	/* to set text in window headline and icon */
#endif

extern char yank_file [];	/* Temp. file for buffer */
extern char yankie_file [];	/* Temp. file for inter-window buffer */
extern char html_file [];	/* Temp. file for HTML embedding buffer */
extern char panic_file [];	/* file for panic-write-back */
extern FLAG yank_status;	/* Status of yank_file */
extern FLAG redraw_pending;	/* was a redraw suppressed in find_y ? */
extern long chars_saved;	/* # of chars saved in paste buffer */
extern long bytes_saved;	/* # of bytes saved in paste buffer */
extern int lines_saved;	/* # of lines saved in paste buffer */

extern int hop_flag;		/* set to 2 by HOP key function */
extern int buffer_open_flag;	/* counter flag for the collective buffer */
extern int JUSlevel;		/* keep justified while typing? */
extern int JUSmode;		/* 1: paragraphs end at empty line */
extern FLAG autoindent;		/* auto indent on input of Enter? */
extern FLAG dim_HTML;		/* display HTML dimmed ? */
extern FLAG insert_mode;	/* insert or overwrite */
extern FLAG append_flag;	/* Set when buffer should be appended to */
extern character erase_char;	/* effective (configured) char for erase left */
extern char emulation;		/* 'w' for WordStar, 'e' for emacs */
extern FLAG emacs_buffer;	/* enable emacs buffer fct for ^K/^T */
extern FLAG paste_stay_left;	/* cursor stays before pasted region */
extern character control_prefix; /* ^V/^P/^Q character to prefix control chars */
extern character quit_char;	/* ^\/^G character to cancel command */
extern FLAG Turkish;		/* use Turkish case toggle specials ? */
extern FLAG Lithuanian;		/* use Lithuanian case toggle specials ? */
extern FLAG smart_quotes;	/* replace " with typographic quote ? */

extern FLAG utf8_screen;	/* screen driven in UTF-8 mode ? */
extern FLAG utf8_input;		/* keyboard input in UTF-8 mode ? */
extern FLAG cjk_term;		/* terminal in CJK mode ? */
extern FLAG cjk_uni_term;	/* terminal in CJK mode with Unicode widths ? */
extern FLAG gb18030_term;	/* does CJK terminal support GB18030 ? */
extern FLAG euc3_term;		/* does CJK terminal support EUC 3 byte ? */
extern FLAG euc4_term;		/* does CJK terminal support EUC 4 byte ? */
extern FLAG cjklow_term;	/* does CJK terminal support 81-9F range ? */
extern int cjk_tab_width;	/* width of CJK TAB indicator */
extern int cjk_lineend_width;	/* width of CJK line end indicator */
extern FLAG combining_screen;	/* UTF-8 combining character terminal ? */
extern FLAG bidi_screen;	/* UTF-8 bidi terminal ? */
extern int width_data_version;
extern int nonbmp_width_data;
extern int combining_data_version;
extern FLAG suppress_unknown_cjk;	/* on CJK terminal if no Unicode mapping */
extern FLAG suppress_extended_cjk;	/* on CJK terminal if in extended code range */
extern FLAG suppress_invalid_cjk;	/* on CJK terminal if invalid CJK code */
extern FLAG utf_cjk_wide_padding;	/* always display CJK on UTF double-width ? */

extern FLAG cjk_text;		/* text in CJK encoding ? */
extern FLAG utf8_text;		/* text in UTF-8 representation ? */
extern FLAG mapped_text;	/* text in 8 bit, non-Latin-1 representation ? */
extern FLAG utf8_lineends;	/* support UTF-8 LS and PS line ends ? */
extern FLAG poormansbidi;	/* poor man's bidirectional support ? */
extern FLAG disp_scrollbar;	/* shall scrollbar be displayed ? */
extern FLAG fine_scrollbar;	/* fine-grained UTF-8 scrollbar ? */
extern FLAG update_scrollbar_lazy;	/* partial scrollbar refresh as needed ? */
extern FLAG combining_mode;	/* UTF-8 combining character support ? */
extern FLAG display_block_graphics;	/* display control chars as graphics */
extern FLAG no_window_title;	/* suppress filename display in window title? */

extern long last_delta_readchar;	/* delay between last 2 characters */
extern long average_delta_readchar;	/* average delay between last characters */
extern FLAG loading;		/* Loading a file? Init True for error handling */
extern char file_name [];	/* name of file being edited */
extern char screen [];		/* I/O buffer for "writes" and "reads" */
extern FLAG wordnonblank;	/* handle all non-blank sequences as words */
extern FLAG proportional;	/* Enable support for proportional fonts? */
extern FLAG translate_output;	/* Transform output diacritics to strings */
extern char * transout;		/* Output transformation table */
extern char * dimansi;		/* special character dimming ANSI sequence */
extern char * ctrlansi;		/* control character display ANSI sequence */
extern char * uniansi;		/* Unicode character display ANSI sequence */
extern char * unimarkansi;	/* Unicode (lineend) marker display ANSI sequence */
extern char * combiningansi;	/* combining character display ANSI sequence */
extern char * menuansi;		/* menu line ANSI sequence */
extern char * HTMLansi;		/* HTML display ANSI sequence */
extern char * diagansi;		/* dialog (bottom status) line ANSI sequence */
extern char * scrollfgansi;	/* scrollbar foreground ANSI sequence */
extern char * scrollbgansi;	/* scrollbar background ANSI sequence */
extern int translen;		/* length of " */
extern FLAG controlQS;		/* must respect ^Q/^S handshake ? */
extern int display_delay;	/* delay between display lines */

extern char TABchar;		/* Char to be shown in place of tab chars */
extern char TABchar0;		/* Char to be shown at start of tab chars */
extern char TABchar2;		/* Char to be shown at end of tab chars */
extern char TABcharmid;		/* Char to be shown in middle of tab chars */
extern unsigned long CJK_TAB_MARK;	/* to be shown in place of tab */
extern char SHIFT_BEG;		/* Char indicating that line continues left */
extern char RET_MARK;		/* Char indicating end of line */
extern char DOSRET_MARK;	/* Char indicating DOS end of line */
extern char PARA_MARK;		/* Char indicating end of paragraph */
extern char RET_BLANK;		/* Char to fill the end of line with */
extern char RET_BLANK2;		/* Char to fill last position of line with */
extern char * UTF_TAB;		/* Char to be shown in place of tab chars */
extern char * UTF_TAB0;		/* Char to be shown at start of tab chars */
extern char * UTF_TAB2;		/* Char to be shown at end of tab chars */
extern char * UTF_TABmid;	/* Char to be shown in middle of tab chars */
extern char * UTF_RET;		/* Char indicating end of line */
extern char * UTF_DOSRET;	/* Char indicating DOS end of line */
extern char * UTF_PARA;		/* Char indicating end of paragraph */
extern char * UTF_RETblank;	/* Char to fill the end of line with */
extern char * UTF_RETblank2;	/* Char to fill last position of line with */
extern char UNI_MARK;		/* char to be shown in place of Unicode char */
extern char TABdefault;		/* Char displayed instead of TABs */
extern char RETdefault;		/* Char displayed to indicate line-end */
extern char DOSRETdefault;	/* Char displayed to indicate DOS line-end */
extern char PARAdefault;	/* Char displayed to indicate end of paragraph */
extern FLAG paradisp;		/* Shall paragraph end be distinguished? */
extern char SHIFT_MARK;		/* Char indicating that line continues */
extern character ring;		/* Ring accent character */
#define UNI_ring (character) ''
#define UNI_acute (character) ''
#define DOS_ring (character) 0xF8
#define DOS_acute (character) 0xEF
#ifdef pc_charset
#define pc_term True
#else
extern FLAG pc_term;		/* PC (CP437) character set ? */
#endif

extern FLAG stat_visible;	/* Set if status line is visible */
extern FLAG top_line_scrolled;	/* Was menu line scrolled away? */
extern FLAG always_disp_fstat;	/* Permanent file status display on status line? */
extern FLAG always_disp_code;	/* Permanent char code display on status line? */
extern FLAG always_disp_Han;	/* Permanent Han character description display on status line? */
extern FLAG disp_Han_Mandarin;	/* display this Han pronunciation ? */
extern FLAG disp_Han_Cantonese;	/* display this Han pronunciation ? */
extern FLAG disp_Han_Japanese;	/* display this Han pronunciation ? */
extern FLAG disp_Han_Sino_Japanese;	/* display this Han pronunciation ? */
extern FLAG disp_Han_Korean;	/* display this Han pronunciation ? */
extern FLAG disp_Han_Vietnamese;	/* display this Han pronunciation ? */
extern FLAG disp_Han_description;	/* display Han description ? */
extern FLAG disp_Han_full;	/* display full Han description ? */

extern FLAG use_extracset;	/* Set if MINEDMARK enables graph. mark mode */
extern FLAG use_curses;		/* True if compiled with CURSES */

extern char * pc_charmap;	/* PC character set mapping */

extern voidfunc key_map [256];
extern voidfunc ws_key_map [32];
extern voidfunc emacs_key_map [32];
extern voidfunc pc_fkey_map [256];

extern FLAG page_scroll;	/* use scroll for page up/down */
extern FLAG page_stay;		/* stay at edge of page after page up/down */
extern FLAG cansuspendmyself;

/* terminal feature indications */
extern FLAG can_scroll_reverse;
extern FLAG can_add_line;
extern FLAG can_delete_line;
extern FLAG can_clear_eol;
extern FLAG can_alt_cset;


/***************************************************************************\
	declaration of mined functions
\***************************************************************************/

/* text buffer navigation */
/* from textbuf.c */
extern LINE * proceed _((LINE *, int));
extern void reset _((LINE * scr_top, int y));
extern void move_y _((int y));
extern void move_to _((int x, int y));
extern void move_address _((char *, int y));
extern void move_address_w_o_RD _((char *, int y));
extern int find_x _((LINE * line, char * address));
extern int get_cur_col _((void));
/* from mined2.c */
extern int find_y _((LINE * line));
extern int find_y_w_o_RD _((LINE * line));

/* file handling */
/* from textbuf.c */
extern int get_line _((int fd, char * buffer, int * len));
extern int panicwrite _((void));

/* text buffer status handling */
/* from mined1.c */
extern void set_modified _((void));
/* from textbuf.c */
extern FLAG checkoverwrite _((char *));
extern void file_status _((char * message, long bytecount, long charcount, 
			char * filename, int lines, FLAG textstat, 
			FLAG writefl, FLAG changed, FLAG viewing));
extern void calc_line_no _((void));

/* from mined2.c */
extern void delete_yank_files _((void));
extern int scratchfile _((FLAG read_write, FLAG append, char * buf_name, char * which, FLAG * buf_status));
extern int yankfile _((FLAG read_write, FLAG append));


/* editing functions */
/* from mined2.c */
extern void yank_HTML _((FLAG remove));
extern void paste_HTML _((void));
/* from minedaux.c */
extern int delete_text _((LINE * startl, char * start, LINE * endl, char * end));
extern LINE * line_insert _((LINE *, char *, int, lineend_type));
extern int insert _((LINE *, char * location, char * string));
/* from textbuf.c */
extern void edit_nth_file _((int));
extern FLAG save_text_load_file _((char * filename));
extern lineend_type extract_lineend_type _((char *, int));
extern lineend_type default_lineend;

/* character input handling */
/* from mined2.c */
extern void insert_grave _((void));
extern void insert_circumflex _((void));
extern void insert_acute _((void));
extern void insert_diaeresis _((void));
extern void insert_tilde _((void));
extern void insert_angstrom _((void));
extern void shift_0 _((void));
extern void shift_1 _((void));
extern void shift_2 _((void));
extern void shift_3 _((void));
extern void shift_4 _((void));
extern void shift_5 _((void));
extern void shift_6 _((void));
extern void shift_7 _((void));
extern void shift_8 _((void));
extern void shift_9 _((void));

/* from keydefs.c */
extern unsigned long compose _((unsigned long, unsigned long));
extern unsigned long compose_mnemonic _((char *));
extern unsigned long grave _((unsigned long));
extern unsigned long circumflex _((unsigned long));
extern unsigned long acute _((unsigned long));
extern unsigned long diaeresis _((unsigned long));
extern unsigned long tilde _((unsigned long));
extern unsigned long angstrom _((unsigned long));

/* status line handling */
/* from prompt.c */
extern void rd_bottom_line _((void));
extern void redraw_prompt _((void));
extern void clear_lastline _((void));
extern int get_filename _((char * message, char * filename));


/* keyboard input */
extern voidfunc keyproc;	/* function addressed by entered function key */
extern int ansi_params;
extern int ansi_param [];
extern char ansi_fini;
extern char keyshift;		/* shift state of entered function key */
/* shift state indications of escape sequences */
/*
ctrl	alt	shift	ESC code/ -1	keyshift code
0	0	0	0		000
0	0	1	2	1	001
0	1	0	3	2	010
0	1	1	4	3	011
1	0	0	5	4	100
1	0	1	6	5	101
1	1	0	7	6	110
1	1	1	8	7	111
*/
/* shift state masks (indications decremented by 1) */
#define ctrl_mask	0x4
#define alt_mask	0x2
#define shift_mask	0x1
#define ctrlshift_mask	(ctrl_mask | shift_mask)
#define altshift_mask	(alt_mask | shift_mask)
#define altctrl_mask	(alt_mask | ctrl_mask)
#define altctrlshift_mask	(alt_mask | ctrl_mask | shift_mask)


/*
 * Convert cnt to nearest tab position
 */
extern int tabsize;
#define tab(cnt)		(((cnt) + tabsize) & ~(tabsize - 1))
#define tab8(cnt)		(((cnt) + 8) & ~07)
#define is_tab(c)		((c) == '\t')
/*
 * Word definitions
 */
#define white_space(c)	((c) == ' ' || (c) == '\t')
#define alpha(c)	((c) != ' ' && (c) != '\t' && (c) != '\n')

/* Set cursor at coordinates x, y */
#define set_cursor(nx, ny)	move_cursor(nx, ny)


/* from textbuf.c */
extern void reset_get_line _((void));
extern void show_get_l_errors _((void));

/* from mined2.c */
extern int get_idf _((char * idf_buf, char * text, char * start_line));

/* from search.c */
extern void search_for _((char *, FLAG));
extern void search_expr _((char *, FLAG));
extern void search_corresponding _((char *, FLAG, char *));
/* from mined2.c */
extern void viewonlyerr _((void));
extern void restrictederr _((void));


/* file output functions */
/* from textbuf.c */
extern int writechar _((int fd, char));
extern int write_lineend _((int fd, lineend_type return_type));

/* special stuff */
/* from minedaux.c */
extern char * envvar _((char * name));
extern void catch_interrupt _((int));
extern void panic _((char *, char *));
extern void panicio _((char * message, char * err));
extern char * scan_int _((char *, int *));
extern char * dec_out _((long));
extern char * serror _((void));
extern char * serrorof _((int));
extern int geterrno _((void));
extern char syntax_state _((char, char *));
extern void update_text_state _((LINE *));
extern void delete_file _((char *));
extern char * unnull _((char *));
extern void copy_string _((char * to, char * from));

/* memory allocation */
/* from minedaux.c */
extern void * alloc _((int bytes));
extern void free_space _((void *));
extern LINE * alloc_header _((void));
extern void free_header _((LINE *));

/* command dispatch mapper */
/* from mined1.c */
extern voidfunc command _((unsigned long));


/* prompt line */
/* from prompt.c */
extern character promptyn _((void));
extern FLAG char_on_status_line; /* is output active on status line ? */
extern FLAG input_active;
extern int lpos;
extern long get_number _((char * message, char firstdigit, int * result));
extern int prompt_num_char _((unsigned long * result, unsigned long maxvalue));


/* character properties */
/* from mined2.c */
extern char * script _((unsigned long));
/* from charmaps.c */
extern int iscontrol _((character));
extern character controlchar _((character));

/* output functions */
/* from mined1.c */
extern void RDwin _((void));
extern void RD_window_title _((void));
extern void clear_window_title _((void));
extern void RD_y _((int y_pos));
/* from output.c */
extern void display _((int y, LINE *, int count, int new_pos));
extern void bad_write _((int fd));
/* from output.c */
extern FLAG display_scrollbar _((FLAG update));
extern void scrollbar_scroll_up _((int from));
extern void scrollbar_scroll_down _((int from));
/* from output.c */
extern void putmark _((char mark, char * utfmark));
extern void put_blanks _((int endpos));
extern int flush_buffer _((int fd));
#define flushout()	flush_buffer (output_fd)
extern void set_cursor_xy _((void));
extern void put_line _((int scr_y, LINE *, int offset, FLAG clear, FLAG prop_pos));
#define putchar(c)	__putchar ((character) c)
extern void put1utfchar _((char *));
/* put character values */
extern void putcharacter _((character));
extern void _put_unichar _((unsigned long));
extern int _put_cjkchar _((unsigned long));
/* insert cast needed for Turbo-C: */
#define put_unichar(c)	_put_unichar ((unsigned long) c)
#define put_cjkchar(c)	_put_cjkchar ((unsigned long) c)
/* low-level functions */
extern int putoutchar _((character));
extern void putoutstring _((char *));

/* character handling */
/* from minedaux.c */
extern int length_of _((char *));
/* from mined1.c */
extern int utf8_col_count _((char *));
extern int char_count _((char *));
extern int utf8_count _((char *));
extern int col_count _((char *));
extern char * charbegin _((char *, char *));
extern void advance_utf8_scr _((char * *, int *, char *));
extern void advance_utf8 _((char * *));
extern void advance_char_scr _((char * *, int *, char *));
extern void advance_char _((char * *));
extern void precede_char _((char * *, char *));
extern unsigned long charvalue _((character *));
extern unsigned long unicodevalue _((character *));
extern unsigned long unicode _((unsigned long));
extern unsigned long precedingchar _((char *, char *));
extern int uniscrwidth _((unsigned long, char *, char *));
extern int cjkscrwidth _((unsigned long, char *, char *));
extern int UTF_len _((char));
extern int CJK_len _((character *));
extern int UTFseq_len _((char *));
extern void utf8_info _((char *, int *, unsigned long *));
extern int isjoined _((unsigned long, char *, char *));
extern int iscombined _((unsigned long, char *, char *));
#define multichar(c)	((character) c >= 0x80 && (cjk_text == False || cjk_encoding != 'S' || (character) c < 0xA1 || (character) c > 0xDF))

/* from iscombin.c, iswide.c, isrtol.c */
extern int iscombining _((unsigned long));
extern int iswide _((unsigned long));
extern int is_right_to_left _((unsigned long ucs));
/* from locale.c, encoding.c */
extern int is_locale_utf8 _((void));
extern char * locale_terminal_encoding _((void));
extern char * locale_text_encoding _((void));

/* from charmaps.c */
extern int uniUTF _((unsigned long, character *));
extern int cjkencode _((unsigned long, character *));
extern char * encode_char _((unsigned long));
extern FLAG valid_cjk _((unsigned long cjkchar, /* opt */ character * cjkbytes));
extern unsigned long isolated_alef _((unsigned long));

/* character encoding handling */
#define CHAR_UNKNOWN -2	/* unknown mnemonic */
#define CHAR_INVALID -1	/* not mappable to encoding */
#define no_char(c)	(c == CHAR_UNKNOWN || c == CHAR_INVALID)
/* from charmaps.c */
extern unsigned long cjk _((unsigned long));
extern unsigned long lookup_cjk _((unsigned long));
extern unsigned long max_char_value _((void));
extern FLAG encoding_has_combining _((void));
extern char get_char_encoding _((void));
extern FLAG set_char_encoding _((char));
extern char cjk_encoding;
extern char * cjk_encoding_flag;


/* Han character descriptions table */
struct hanentry {
	unsigned long unicode;
	char * Mandarin;
	char * Cantonese;
	char * Japanese;
	char * Sino_Japanese;
	char * Korean;
	char * Vietnamese;
	char * Definition;
};

extern struct hanentry hantable [];
extern unsigned int hantable_len;


/* keyboard mapping tables */
#define keymapping_stringtables
#ifdef keymapping_stringtables
#define keymaptabletype char *
#else
#define keymaptabletype struct keymap *
struct keymap {
	char * fk;
	char * fp;
};
#endif

extern struct keymapping {
	keymaptabletype table;
	char * shortcut;
} keymappingtable [];
extern unsigned int keymappingtable_len;


/* keyboard mapping menu handling */
extern char selection_space;
extern FLAG enforce_keymap;	/* enable keyboard mapping even on non-suitable terminal */
#define allow_keymap ((utf8_input && (utf8_text || cjk_text || mapped_text)) || cjk_term || enforce_keymap)
#define SPACE_NEXT	'n'
#define SPACE_NEXTROW	'r'
#define SPACE_SELECT	's'

/* menu handling */
typedef struct {
	char * itemname;
	voidfunc itemfu;
	char * hopitemname;
	flagfunc itemon;
	char tag;
	} menuitemtype;
extern void separator _((void));
extern mousebutton mouse_button, mouse_lastbutton, mouse_prevbutton;
extern int mouse_shift;
extern int mouse_xpos, mouse_ypos, mouse_lastxpos, mouse_lastypos;
extern FLAG report_release;
extern FLAG flags_changed;	/* Should flag menu area be redrawn? */
extern FLAG in_menu_border;
/* from mousemen.c */
extern void QUICKMEN _((int column, int line));
extern void openmenu _((int meni)), openmenuat _((int col));
extern int popup_menu _((menuitemtype *, int menulen, int column, int line, 
			char * title, FLAG disp_only, char * select_keys));
extern void clean_menus _((void));
extern int is_menu_open _((void));
extern void displaymenuline _((void));
extern void redrawmenu _((void));
extern void displayflags _((void));
extern void toggleappend _((void));
extern void set_scripttag _((void));
extern void handleKeymapmenu _((void));
extern void handleQuotemenu _((void));
extern void handleEncodingmenu _((void));

/* from mined2.c */
extern int quote_type;
extern void quote_type_down _((void));
extern void quote_type_up _((void));
extern void set_quote_type _((int));
extern void set_quote_style _((char *));
/* from mousemen.c */
extern int count_quote_types _((void));
extern char * quote_mark _((int, int));
extern int lookup_quotes _((char *));

/* The main editing functions */

extern void invoke_key_function _((unsigned long));

extern void QUICKMENU _((void)), FILEMENU _((void)), EDITMENU _((void));
extern void SEARCHMENU _((void)), EXTRAMENU _((void)), PARAMENU _((void));
extern void handleFlagmenus _((void));
extern void MOUSEescape _((void));
extern void ANSIseq _((void));
extern void MUP _((void)), MDN _((void)), MLF _((void)), MRT _((void)), MNW _((void)), MPW _((void));
extern void ctrl_MLF _((void)), ctrl_MRT _((void));
extern void BSEN _((void)), ESEN _((void));
extern void SD _((void)), SU _((void)), PD _((void)), PU _((void)), BFILE _((void)), EFILE _((void));
extern void BLINE _((void)), ELINE _((void)), MPPARA _((void)), MNPARA _((void)), HIGH _((void)), LOW _((void));
extern void SNL _((void)), LIB _((void)), Underline _((void));
extern void DPC _((void)), DCC _((void)), DLN _((void)), DNW _((void)), DPW _((void));
extern void DCC0 _((void)), DPC0 _((void));
extern void CTRLINS _((void)), DLINE _((void)), TOGINS _((void)), ctrlQ _((void)), ctrlK _((void)), ctrlO _((void));
extern void search_wrong_enc _((void));
extern void JUS _((void)), JUSclever _((void)), JUSandreturn _((void));
extern void QUED _((void)), WT _((void)), WTU _((void)), SAVEAS _((void)), SAVPOS _((void)), EDIT _((void)), NN _((void));
extern void RD _((void)), RDwin _((void)), I _((void));
extern void EXED _((void)), VIEW _((void)), GOTO _((void)), GOMA _((void)), HELP _((void));
extern void SFW _((void)), SRV _((void)), RS _((void)), LR _((void)), GR _((void)), REPL _((void));
extern void MARK _((void)), COPY _((void)), CUT _((void)), PASTE _((void)), PASTEstay _((void)), YANKRING _((void));
extern void WB _((void)), INSFILE _((void));
extern void HOMEkey _((void)), ENDkey _((void)), DELkey _((void)), smallHOMEkey _((void)), smallENDkey _((void));
extern void HOP _((void)), CANCEL _((void)), ESCAPE _((void)), FUNKEY _((void));
extern void EMAX _((void)), META _((void)), UNDO _((void));
extern void CHDI _((void)), PRINT _((void)), CMD _((void)), SH _((void)), SUSP _((void));
extern void LNCI _((void)), LNSW _((void));
extern void LOWCAP _((void)), LOWER _((void)), UPPER _((void)), CAPWORD _((void));
extern void Stag _((void));
extern void SIDFW _((void)), SIDRV _((void)), HTML _((void)), MARKER _((void)), GOMARKER _((void));
extern void EDITmode _((void)), VIEWmode _((void)), toggleVIEWmode _((void));
extern void NXTFILE _((void)), PRVFILE _((void)), NTHFILE _((void)), EXFILE _((void)), EXMINED _((void));
extern void ADJLM _((void)), ADJFLM _((void)), ADJNLM _((void)), ADJRM _((void)), ADJPAGELEN _((void));
extern void FS _((void)), FSTAT _((void)), HELPF _((void)), HELPS _((void)), HELPC _((void)), HELPA _((void));
extern void display_code _((void)), display_the_code _((void));
extern void display_Han _((char * cpoi, FLAG force_utf8));
extern void toggletab _((void));
extern void changeuni _((void)), changehex _((void)), changeoct _((void)), changedec _((void));
extern void screensmaller _((void)), screenbigger _((void)), screenlesslines _((void)), screenmorelines _((void));

extern void toggleKEYMAP _((void)), setupKEYMAP _((void));
extern void toggle_encoding _((void));

extern void Sdoublequote _((void)), Ssinglequote _((void)), Sdash _((void));
extern void S _((character)), S0 _((character)), Scharacter _((unsigned long));

extern void goline _((int)), goproz _((int));

extern void SIDF _((FLAG));
extern void Pushmark _((void)), Popmark _((void));
extern void MARKn _((int)), GOMAn _((int)), Markn _((int));
extern void UML _((char)), REPT _((char));
extern void BADch _((unsigned long cmd));
extern void SCORR _((FLAG pref_direction));

extern void checkout _((void)), checkin _((void));


/*
 * String functions
 */
#define streq(s1, s2)		(strcmp (s1, s2) == 0)
#define strisprefix(s1, s2)	(strncmp (s2, s1, strlen (s1)) == 0)

/*
 * Empty output buffer
 */
#define clear_buffer()		(out_count = 0)

/*
 * Print line on terminal at offset 0 and clear tail of line
 */
#define line_print(scry, line)	put_line (scry, line, 0, True, False)

/*
 * Functions handling status_line. ON means in reverse video.
 */
extern int bottom_line _((FLAG revfl, char *, char *, char * inbuf, FLAG statfl, char * term_input));
#define status_msg(str)		status_line (str, NIL_PTR)
#define status_line(str1, str2)	\
	(void) bottom_line (ON, (str1), (str2), NIL_PTR, False, "")
#define status_beg(str)		\
	(void) bottom_line (ON, (str), NIL_PTR, NIL_PTR, True, "")
#define error(str1)		\
	(void) bottom_line (ON, (str1), NIL_PTR, NIL_PTR, False, "")
#define error2(str1, str2)	\
	(void) bottom_line (ON, (str1), (str2), NIL_PTR, False, "")
#define clear_status()		\
	(void) bottom_line (OFF, NIL_PTR, NIL_PTR, NIL_PTR, False, "")
#define get_string(str1, str2, fl, term_chars)	\
	bottom_line (ON, (str1), NIL_PTR, (str2), fl, term_chars)

/*
 * Print info about current file and buffer.
 */
#define fstatus(mess, bytes, chars)	\
	file_status ((mess), (bytes), (chars), file_name, total_lines, True, writable, modified, viewonly)

/*
 * Build formatted string.
 * If this definition is left out, a routine will be defined in mined1.c.
 */
#define build_string sprintf
#ifndef build_string
extern void build_string ();
#endif

/*
 * Get real shift value.
 */
#define get_shift(cnt)		((cnt) & DUMMY_MASK)


/***************************************************************************\
	end
\***************************************************************************/
