//  $Id: mmdb_align.h,v 1.5 2005/11/17 18:07:17 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    30.05.03   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  MMDB_Align <interface>
//       ~~~~~~~~~
//  **** Classes    :  CAlignment  ( alignment of character strings )
//       ~~~~~~~~~~~~  CAlignment1 ( alignment of integer vectors   )
//
//  (C) E.Krissinel'  2000-2003
//
//  =================================================================
//

#ifndef __MMDB_Align__
#define __MMDB_Align__

#ifndef  __Stream__
#include "stream_.h"
#endif


//  =====================   CAlignParams   ======================


DefineClass(CAlignParams);
DefineStreamFunctions(CAlignParams)

class CAlignParams : public CStream  {

  public :

    realtype  gapWeight,spaceWeight;
    realtype  equalScore,nequalScore;
    int       method;

    CAlignParams();
    CAlignParams ( RPCStream Object );

    void write ( RCFile f );
    void read  ( RCFile f );

  protected :
    void InitAlignParams();

};


//  =====================   CAlignment   ======================

DefineClass(CAlignment)

#define ALIGN_GLOBAL    0
#define ALIGN_LOCAL     1
#define ALIGN_GLOBLOC   2
#define ALIGN_FREEENDS  3

class  CAlignment : public CStream  {

  public :

    CAlignment  ();
    CAlignment  ( RPCStream Object );
    ~CAlignment ();

    void SetAffineModel ( realtype WGap,   realtype WSpace  );
    void SetScores      ( realtype SEqual, realtype SNEqual );

    void Align          ( const pstr S, const pstr T,
                          int Method=ALIGN_GLOBAL );

    pstr     GetAlignedS()  {  return AlgnS;      }
    pstr     GetAlignedT()  {  return AlgnT;      }
    realtype GetScore   ()  {  return VAchieved;  }
    char     GetSpace   ()  {  return Space;      }

    virtual void OutputResults ( RCFile f, const pstr S, 
                                           const pstr T  );

    void read   ( RCFile f );
    void write  ( RCFile f );

  protected :

    char     Space;
    int      AlignKey, SLen,TLen;
    rmatrix  VT,ET,FT;
    pstr     AlgnS,AlgnT;
    realtype VAchieved;
    realtype SEq,SNEq, Wg,Ws;

    virtual void  InitAlignment();
    virtual void  FreeMemory   ();
    virtual realtype  Score    ( char A, char B );

    void    BuildGATable ( const pstr S, const pstr T,
                           Boolean FreeSEnd, Boolean FreeTEnd );
    void    BuildLATable ( const pstr S, const pstr T );
    void    Backtrace    ( const pstr S, const pstr T, int J, int I,
                           Boolean StopAtZero );
    void    AdjustEnds   ( const pstr S, const pstr T, int J, int I );
    void    PrintVT      ( const pstr S, const pstr T );

};



//  =====================   CAlignment1   ======================

DefineClass(CAlignment1)

class  CAlignment1 : public CStream  {

  public :

    CAlignment1 ();
    CAlignment1 ( RPCStream Object );
    ~CAlignment1();

    void SetAffineModel ( realtype WGap,   realtype WSpace  );
    void SetScores      ( realtype SEqual, realtype SNEqual );

    void Align          ( ivector S, int SLength,
                          ivector T, int TLength,
                          int Method=ALIGN_GLOBAL );

    ivector  GetAlignedS   ()  { return AlgnS;     }
    ivector  GetAlignedT   ()  { return AlgnT;     }
    int      GetAlignLength()  { return AlgnLen;   }
    realtype GetScore      ()  { return VAchieved; }

    virtual void OutputResults ( RCFile f, ivector S, int lenS,
                                           ivector T, int lenT );

    void read   ( RCFile f );
    void write  ( RCFile f );

  protected :

    int      Space;
    int      AlignKey, SLen,TLen, AlgnLen;
    rmatrix  VT,ET,FT;
    ivector  AlgnS,AlgnT;
    realtype VAchieved;
    realtype SEq,SNEq, Wg,Ws;

    virtual void  InitAlignment1();
    virtual void  FreeMemory    ();
    virtual realtype  Score     ( int A, int B );

    void    BuildGATable ( ivector S, ivector T,
                           Boolean FreeSEnds, Boolean FreeTEnds );
    void    BuildLATable ( ivector S, ivector T );
    void    Backtrace    ( ivector S, ivector T, int J, int I,
                           Boolean StopAtZero );
    void    AdjustEnds   ( ivector S, ivector T, int J, int I );
    void    PrintVT      ( ivector S, ivector T );

};


#endif
