      subroutine m_adpi(nmode,nf,nh,idelim,ierr)
C
C------------------------------------------------------------------------------
C     Routine to add a new dipion invariant mass function
C     or to specify the masses for an existing one
C     Mode = 0 add a new one
C     Mode = 1 specify the masses for an exisintg one
C------------------------------------------------------------------------------
C
      implicit none
C
#include "mnpar.inc"
#include "mnfun.inc"
#include "mnfit.inc"
#include "mnluj.inc"
#include "mnlun.inc"
C
      integer nmode,nf,nh,idelim,ierr
C
      integer nline,i,ii,nn1,nn2,lmodel,nresp,nresd,nmodpi,ioerr
      real eres,edau,ampi
*
      integer  inttyq
      real     valtyq
      external inttyq,valtyq
C
      IERR = 1
C
      if(nmode.eq.0) then
          IF(IDELIM.LT.0) THEN
              CALL MN_MES(LUNTTO,'I'
     +         ,' The following models are available')
              NLINE = (MMPIPI-2) / 3 + 1
              DO 1000,I=1,NLINE
                  NN1 = (I-1) * 3 + 1
                  NN2 = I * 3
                  WRITE(TXTMES,'(1X,3(I2,'': '',A,2X))',IOSTAT=IOERR)
     +             (II,TPIPI(II),II=NN1,NN2)
                  CALL MN_MES(LUNTTO,'I',TXTMES)
 1000         CONTINUE
              CALL MN_MES(LUNTTO,'E',' ')
          ENDIF
          CALL WAITYQ('Give model number: ')
          LMODEL = INTTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(LMODEL,IDELIM,IERR)
          IF(IERR.EQ.2) GOTO 9000
          IF(IERR.NE.0) GOTO 9000
          IF(LMODEL.LE.0 .OR. LMODEL.GT.MMPIPI) GOTO 9000
          XFXPAR(1,NF)   = FLOAT(LMODEL)
          TUSEF(NF)(17:) = TPIPI(LMODEL)
          IPARF(NF)      = IPPIPI(LMODEL)
          DO 2000 II=1,IPPIPI(LMODEL)
              TPARF(II,NF) = TPPIPI(II,LMODEL)
 2000     CONTINUE
      endif
C
C     Get the resonances associated with the function
C
      if(idelim.lt.0) then
          txtmes = ' Built in resonances masses are:'
          call mn_mes(luntto,'I',txtmes)
          do i=1,13
              write(txtmes,'(1x,I2,'':'',1x,A,2x,f8.5)')
     +         i,resnam(i),resmas(i)
              call mn_mes(luntto,'I',txtmes)
          enddo
          txtmes =
     +     ' Normal parent resonances are: 2=U(2S),3=U(3S),11=Psi(2S)'
          call mn_mes(luntto,'I',txtmes)
          txtmes =
     +     ' Normal daughter resonances are: ' //
     +     '1=U(1S),2=U(2S),5=U(1P1),7=J/Psi'
          call mn_mes(luntto,'I',txtmes)
          txtmes =
     +     ' Give mass as a real number if you want your own'
          call mn_mes(luntto,'IE',txtmes)
      endif
      CALL WAITYQ('Give parent resonance number or mass: ')
      NRESP = INTTYQ(.TRUE.,IDELIM)
      if(idelim.gt.0) then
          call restyq
          eres = valtyq(.true.,idelim)
          call mn_rck(eres,idelim,ierr)
          if(ierr.gt.0) goto 9000
          if(eres.le.0.0) then
              call mn_err('M_ADPI','Resonance mass < 0')
              ierr = 1
              goto 9000
          endif
      else
          CALL MN_NCK(NRESP,IDELIM,IERR)
          IF(IERR.GT.0) GOTO 9000
          ERES = RESMAS(NRESP)
      endif
      XFXPAR(2,NF) = ERES
      if(nmode.eq.1) xftpar(2,nh) = eres
C
      CALL WAITYQ('Give daughter resonance number or mass: ')
      NRESD = INTTYQ(.TRUE.,IDELIM)
      if(idelim.gt.0) then
          call restyq
          edau = valtyq(.true.,idelim)
          call mn_rck(edau,idelim,ierr)
          if(ierr.gt.0) goto 9000
          if(edau.le.0.0) then
              call mn_err('M_ADPI','Resonance mass < 0')
              ierr = 1
              goto 9000
          endif
      else
          CALL MN_NCK(NRESP,IDELIM,IERR)
          IF(IERR.GT.0) GOTO 9000
          EDAU = RESMAS(NRESD)
      endif
      XFXPAR(3,NF) = EDAU
      if(nmode.eq.1) xftpar(3,nh) = edau
*
      CALL WAITYQ('Give the mode. 1 = charged pi, ' //
     + '2 = neutral pi: ')
      NMODPI = INTTYQ(.TRUE.,IDELIM)
      CALL MN_NCK(NRESD,IDELIM,IERR)
      IF(IERR .GT. 2) GOTO 9000
      IF(NMODPI.LT.1 .OR. NMODPI.GT.2)THEN
          CALL MN_ERR('M_ADPI','Mode must be 1 or 2')
          ierr = 1
          GOTO 9000
      ENDIF
      AMPI = 0.13957
      IF(NMODPI .EQ. 2)AMPI = 0.13497
      XFXPAR(4,NF) = AMPI
      if(nmode.eq.1) xftpar(4,nh) = ampi
*
*     Check the the values are consistent
*
      if(eres-edau-2*ampi.le.0.0) then
          call m_emsg('M_ADPI'
     +     ,'Parent - Daughter mass difference too small')
          write(txterr
     +     ,'('' Parent mass'',F8.4,'', Daughter mass'',F8.4)'
     +     ,iostat=ioerr) eres,edau
          call mn_err('M_ADPI',txterr)
          ierr = 1
          goto 9000
      endif
C
      IERR = 0
C
9000  CONTINUE
      END
