      REAL FUNCTION RMNBW(ZAM12,ZMG,ZWG)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNBW
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      DOUBLE PRECISION ZAM12,ZMG,ZWG
      DOUBLE PRECISION XMNBW
C
      EXTERNAL XMNBW
C
      RMNBW = SNGL(XMNBW(ZAM12,ZMG,ZWG))
C
      END

      REAL FUNCTION RMNC2D(NFUN,DPAR,NPAR,NPAR2,X,Y)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNC2D
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER NFUN,NPAR,NPAR2
      DOUBLE PRECISION DPAR(*)
      REAL X,Y
      DOUBLE PRECISION XMNC2D
C
      EXTERNAL XMNC2D
C
      RMNC2D = SNGL(XMNC2D(NFUN,DPAR,NPAR,NPAR2,X,Y))
C
      END

      REAL FUNCTION RMNCLC(NFUN,P,NPAR,NPAR2,X,Y)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNCLC
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER NFUN,NPAR,NPAR2
      DOUBLE PRECISION P(*)
      REAL X,Y
      DOUBLE PRECISION XMNCLC
C
      EXTERNAL XMNCLC
C
      RMNCLC = SNGL(XMNCLC(NFUN,P,NPAR,NPAR2,X,Y))
C
      END

      REAL FUNCTION RMNCNT(P,NPAR,X)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNCNT
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER NPAR
      DOUBLE PRECISION P(*)
      REAL X
      DOUBLE PRECISION XMNCNT
C
      EXTERNAL XMNCNT
C
      RMNCNT = SNGL(XMNCNT(P,NPAR,X))
C
      END


      REAL FUNCTION RMNDFUN(XX,YY,IF,NH,WXPARI,WMNHER)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNCNT
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER IF,NH
      DOUBLE PRECISION WXPARI(*),WMNHER
      REAL XX,YY
      DOUBLE PRECISION XMNDFUN
C
      EXTERNAL XMNDFUN
C
      RMNDFUN = SNGL(XMNDFUN(XX,YY,IF,NH,WXPARI,WMNHER))
C
      END

      REAL FUNCTION RMNFRG(LMODEL,WPAR,NPAR,X)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNFRG
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER LMODEL,NPAR
      DOUBLE PRECISION WPAR(*)
      REAL X
      DOUBLE PRECISION XMNFRG
C
      EXTERNAL XMNFRG
C
      RMNFRG = SNGL(XMNFRG(LMODEL,WPAR,NPAR,X))
C
      END

      REAL FUNCTION RMNHIS(IDHA,IDHB,NMODE,XX,YY,WMNHER)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNHIS
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER IDHA,IDHB,NMODE
      DOUBLE PRECISION WMNHER
      REAL XX,YY
      DOUBLE PRECISION XMNHIS
C
      EXTERNAL XMNHIS
C
      RMNHIS = SNGL(XMNHIS(IDHA,IDHB,NMODE,XX,YY,WMNHER))
C
      END

      REAL FUNCTION RMNHSM(IDHA,IDHB,NMODE,NHS,XX,YY,WMNHER)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNHSM
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER IDHA,IDHB,NMODE,NHS
      DOUBLE PRECISION WMNHER
      REAL XX,YY
      DOUBLE PRECISION XMNHSM
C
      EXTERNAL XMNHSM
C
      RMNHSM = SNGL(XMNHSM(IDHA,IDHB,NMODE,NHS,XX,YY,WMNHER))
C
      END

      REAL FUNCTION RMNRD3(Z,EREAL,BSIG)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNRD3
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      DOUBLE PRECISION Z,EREAL,BSIG
      DOUBLE PRECISION XMNRD3
C
      EXTERNAL XMNRD3
C
      RMNRD3 = SNGL(XMNRD3(Z,EREAL,BSIG))
C
      END

      REAL FUNCTION RMNRES(P,NPAR,X)
C
C-----------------------------------------------------------------------
C
C     Single precision version of XMNRES
C
C     Called from Comis functions
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER NPAR
      DOUBLE PRECISION P(*)
      REAL X
      DOUBLE PRECISION XMNRES
C
      EXTERNAL XMNRES
C
      RMNRES = SNGL(XMNRES(P,NPAR,X))
C
      END
