      SUBROUTINE TVCIRC(XX, YY, SIZE, NCOL, THICK, QFILL)
C
C     Routine for drawing circles - uses HIGZ IGARC
C     Only used for drawing symbols
C
#include "mngrn.inc"
#include "mnpij.inc"
C
      REAL XX,YY,SIZE,THICK
      INTEGER NCOL
      LOGICAL QFILL
C
      integer npt,mpt
      parameter (mpt=101)
      REAL XPT(mpt),YPT(mpt)
      real phi,aunit
      integer i
C
#if ( defined(PLTSUB) )
      INTEGER NPFILL
      REAL SISYMX,SISYMY
#endif

C
C     Don't do anything if no or null output device selected
C
      IF(LPDEV.LE.1) RETURN
C
#if ( defined(HIGZ) )
C
C     Setup filling if requested
C
      IF(QFILL) THEN
          CALL ISFAIS(1)
      ELSE
          CALL ISFAIS(0)
      ENDIF
      CALL ISLN(1)
      CALL ISLWSC(THICK)
      CALL ISPLCI(NCOL)
      CALL ISFACI(NCOL)
      CALL IGSET('LTYP',1.0)
      CALL IGSET('BORD',1.0)
C
C     Use HIGZ routines if required
C
      if(qigarc) then
        CALL IGARC(XX,YY,0.0,size,0.0,0.0)
C
C     Use my code to get round HIGZ bug that sometimes uses
C     wrong symbol and colour
C
      else
        npt = min(mpt,max(9,nint(100.0*rad1)))
        do i=1,npt
          phi = float(i-1)/float(npt-1) * twopi
          xpt(i) = xx + rad1*cos(phi)
          ypt(i) = yy + rad1*sin(phi)
        enddo
C
        IF(QFILL) THEN
          call ifa(npt,xpt,ypt)
        ENDIF
C
        call ipl(npt,xpt,ypt)
      endif
C
#endif
#if ( defined(PLTSUB) )
C
C     Draw the circle by hand as an octogon
C
      SISYMX = SIZE
      SISYMY = SIZE
      NPT = 9
      NPFILL = NPT
      XPT(1) = XX - SISYMX
      YPT(1) = YY + 0.5*SISYMY
      XPT(2) = XX - 0.5*SISYMX
      YPT(2) = YY + SISYMY
      XPT(3) = XX + 0.5*SISYMX
      YPT(3) = YY + SISYMY
      XPT(4) = XX + SISYMX
      YPT(4) = YY + 0.5*SISYMY
      XPT(5) = XX + SISYMX
      YPT(5) = YY - 0.5*SISYMY
      XPT(6) = XX + 0.5*SISYMX
      YPT(6) = YY - SISYMY
      XPT(7) = XX - 0.5*SISYMX
      YPT(7) = YY - SISYMY
      XPT(8) = XX - SISYMX
      YPT(8) = YY - 0.5*SISYMY
      XPT(9) = XX - SISYMX
      YPT(9) = YY + 0.5*SISYMY
      CALL MN_LIN(XPT,YPT,NPT,1,SISYMY,NCOL,THICK)
C
      IF(QFILL) THEN
          CALL TVSFIL(NPFILL,XPT,YPT,NNSYM,XX,YY,SISYMX,SISYMY
     1     ,NCOL)
      ENDIF
C
#endif

      END
