      SUBROUTINE TVELL(XX, YY, RAD1, RAD2, PHI1, PHI2
     + ,NSYM, NCOL, THICK, NHAT, NPAT, nhcol, npcol)
C
C     Routine for drawing ellipses
C
      IMPLICIT NONE
*
#include "mngrn.inc"
#include "mnpij.inc"
C
      REAL XX,YY,RAD1,RAD2,PHI1,PHI2,THICK
      INTEGER NSYM,NCOL,NHAT,NPAT,nhcol,npcol
*
      INTEGER MPT
      PARAMETER (MPT = 101)
      REAL XPT(MPT),YPT(MPT)
      INTEGER I,NPT
      REAL PHI,xx1,yy1,xx2,yy2

C
C     Don't do anything if no or null output device selected
C
      IF(LPDEV.LE.1) RETURN
C
#if ( defined(HIGZ) )
C
C     Setup filling if requested
C
      CALL ISLN(NSYM)
      CALL ISPLCI(NCOL)
      IF(NHAT.NE.0) THEN
          CALL ISFAIS(3)
          CALL ISFASI(NHAT)
          CALL ISFACI(NhCOL)
      ELSEIF(NPAT.EQ.100) THEN
          CALL ISFAIS(1)
          CALL ISFACI(NpCOL)
      ELSEIF(NPAT.EQ.200) THEN
          CALL ISFAIS(0)
      ELSEIF(NPAT.NE.0) THEN
          CALL ISFAIS(2)
          CALL ISFASI(NPAT)
          CALL ISFACI(NpCOL)
      ELSE
          CALL ISFAIS(0)
      ENDIF
      CALL ISLWSC(THICK)
      CALL IGSET('LTYP',FLOAT(NSYM))
      CALL IGSET('BORD',1.0)
C
C     Set up number of points
C
      npt = min(mpt,max(9,nint(100.0*(max(rad1,rad2)))))
*ICB      npt  = 101
      do i=1,npt
          phi = twopi * float(i-1) / float(npt-1)
          xx1 = rad1 * cos(phi)
          yy1 = rad2 * sin(phi)
          xx2 = xx1 * cos(phi1*drad) - yy1 * sin(phi1*drad)
          yy2 = xx1 * sin(phi1*drad) + yy1 * cos(phi1*drad)
          xpt(i) = xx2 + xx
          ypt(i) = yy2 + yy
      enddo
*
      if(nhat.ne.0 .or. npat.ne.0) then
          call ifa(npt,xpt,ypt)
      endif
c
      call ipl(npt,xpt,ypt)
C
#endif
#if ( defined(PLTSUB) )
      WRITE(6,'(
     + '' *** TVELL: Ellipse drawing not supported in PLTSUB'')')
#endif

      END
