      SUBROUTINE MN_FIL(NMODE,LUN,TFILE,IDELIM,IERR)
C
C     NMODE = 1 MEANS UNFORMATTED FILE
C     NMODE = 2 MEANS FORMATTED FILE WITH FORTRAN CARRIAGE CONTROL
C     NMODE = 3 MEANS FORMATTED FILE WITH LIST CARRIAGE CONTROL
C     NMODE = 4 MEANS UNFORMATTED DIRECT ACCESS FILE
C     NMODE = 5 MEANS UNFORMATTED DIRECT ACCESS FILE - OVERWRITE IT
C     NMODE = 6 MEANS FORMATTED DIRECT ACCESS FILE, recl = 80
C     NMODE = 7 MEANS UNFORMATTED DIRECT ACCESS FILE - MRGIN or MRGOUT
C     NMODE = 8 means root file
C     NMODE = -n MEANS OPEN A NEW FILE
C     NMODE = 10+n MEANS DO SAME THING FOR FUNCTIONS
C     NMODE = 20+n MEANS DO SAME THING FOR COMMAND FILES
C     NMODE = 30+n MEANS DO SAME THING FOR DUMP FILE
C     NMODE = 40+n means an arbitrary file, so don't say it is being opened
C     NMODE = 50+n means an arbitrary file, but don't say if it fails
C     LUN   is the unit number. If it is 0 a new unit is selected
C           If it is non-zero the unit is checked to see if it is open
C           and that unit is used.
C     For Unix machines if the input filename contains ~ replace it with TMNHOM
C
      implicit none
C
      INTEGER IQUEST
      COMMON/QUEST/IQUEST(100)
C
#include "mnpar.inc"
#include "mndir.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER NMODE,LUN,IDELIM,IERR
      CHARACTER*(*) TFILE
C
      CHARACTER*255 TXT1,TXT2,CONCT0
      CHARACTER*4 TQUAL
      LOGICAL QOPEN,QQUAL
C
      INTEGER MMODE,luni
      INTEGER nn,ioerr,LENT,LNBLNK,nrecl
      integer  isltyq
      external isltyq
C
      MMODE = MOD(NMODE,10)
      luni = lun
 2000 CONTINUE
      IERR = 0
      IF(NMODE.GT.0 .AND. NMODE.LT.10) THEN
          TFILE = ' '
          CALL WAITYQ('Give filename with histograms: ')
          TQUAL = '.hst'
      ELSEIF(NMODE.GE.10 .AND. NMODE.LT.20) THEN
          TFILE = ' '
          CALL WAITYQ('Give filename with functions: ')
          TQUAL = '.fun'
      ELSEIF(NMODE.GE.20 .AND. NMODE.LT.30) THEN
          CALL WAITYQ('Give filename with commands: ')
          TQUAL = '.mnf'
      ELSEIF(NMODE.GE.40 .AND. NMODE.LT.60) THEN
          TXT1 = TFILE
          TQUAL = '.dat'
          GOTO 2200
      ELSEIF(NMODE.LT.0 .AND. NMODE.GT.-10) THEN
          TFILE = ' '
          CALL WAITYQ('Give filename for histograms: ')
          TQUAL = '.hst'
      ELSEIF(NMODE.LE.-10 .AND. NMODE.GT.-20) THEN
          TFILE = ' '
          CALL WAITYQ('Give filename for functions: ')
          TQUAL = '.fun'
      ELSEIF(NMODE.LE.-20 .AND. NMODE.GT.-30) THEN
          CALL WAITYQ('Give filename to write commands to: ')
          TQUAL = '.mnf'
      ELSEIF(NMODE.LE.-30 .AND. NMODE.GT.-40) THEN
          TXT1 = TFILE
          TQUAL = '.dat'
          GOTO 2200
      ELSEIF(NMODE.LE.-40 .AND. NMODE.GT.-60) THEN
          TXT1 = TFILE
          TQUAL = '.dat'
          GOTO 2200
      ELSE
          WRITE(LUNTTO,'('' MN_FIL: Unknown mode for opening a file''
     1     ,I4)') NMODE
          IERR = 3
          GOTO 9000
      ENDIF
      LENT = ISLTYQ(.TRUE.,IDELIM,TXT1)
C
 2200 CONTINUE
      LENT = LNBLNK(TXT1)
      IF(LENT.LE.0 .OR. TXT1.EQ.' ') THEN
          IERR = 1
          GOTO 9000
      ENDIF
C
C     See if the qualifier is specified
C     Don't add the qualifier for histogram files
C
      QQUAL = .FALSE.
      DO 2400 NN=LENT,1,-1
          IF(TXT1(NN:NN).EQ.'.') THEN
              QQUAL = .TRUE.
              GOTO 2410
#if ( defined(VMS) )
          ELSEIF(TXT1(NN:NN).EQ.']' .OR. TXT1(NN:NN).EQ.':') THEN
#endif
#if ( defined(UNIX) )
          ELSEIF(TXT1(NN:NN).EQ.'/') THEN
#endif
#if ( defined(VMS) || defined(UNIX) )
              GOTO 2410
#endif

          ENDIF
 2400 CONTINUE
 2410 CONTINUE
      IF(ABS(NMODE).GE.10 .AND. .NOT.QQUAL) THEN
          TXT2 = CONCT0(TXT1,TQUAL)
          TXT1 = TXT2
      ENDIF
C
C     Fixup the working directory, environment variables and ~
C     For output files just add the working directory
*     For input files search the path
C
      txt2 = txt1
      if(nmode.lt.0) then
          call m_pfil(2,txt2,ierr)
      else
          call m_pfil(1,txt2,ierr)
      endif
      if(ierr.ne.0) goto 9000
      txt1 = txt2
      lent = lnblnk(txt1)
C
      IF(LUN.LE.0) THEN
          CALL CLEO_GETLUN(LUN,'MN_FIL')
      ENDIF
#if ( !defined(SGI) )
C
C     Decstations die if you try to inquire on a unit where there was
C     an error trying to open a direct access file
C
      INQUIRE(UNIT=LUN,OPENED=QOPEN)
      IF(QOPEN) CLOSE(UNIT=LUN)
#endif

C
      LENT = LNBLNK(TXT1)
      IF(MMODE.EQ.1) THEN
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     +     ,FORM='UNFORMATTED'
     +     ,ACCESS='SEQUENTIAL',IOSTAT=IOERR,ERR=8000
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='OLD',READONLY,SHARED)
#endif
#if ( defined(HPUX) || defined(SGI) )
     +     ,STATUS='OLD',READONLY)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) ) && ( !defined(HPUX) ) && ( !defined(SGI) )
     +     ,STATUS='OLD')
#endif

C
      ELSEIF(MMODE.EQ.2 .OR. MMODE.EQ.3) THEN
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='FORMATTED'
     1     ,ACCESS='SEQUENTIAL',IOSTAT=IOERR,ERR=8000
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='OLD',READONLY,SHARED)
#endif
#if ( defined(HPUX) || defined(SGI) )
     +     ,STATUS='OLD',READONLY)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) ) && ( !defined(HPUX) ) && ( !defined(SGI) )
     +     ,STATUS='OLD')
#endif

C
C     Open a direct access file. Check that the file really
C     is direct access and that the record length I am using is correct.
C     Use RZFILE to do the checking as it seems to work properly!!
C
      ELSEIF(MMODE.EQ.4 .or. MMODE.eq.7) THEN
          nrecl = nrclhb
          if(mmode.eq.4) then
            CALL HROPEN(LUN,'MN_HBIN',TXT1(1:LENT),'SP',NRECL,IOERR)
          else
            CALL HROPEN(LUN,'MRGIN',TXT1(1:LENT),'SP',NRECL,IOERR)
          endif
          IF(IOERR.NE.0) THEN
C
C             Try to fix up the file
C
              IF(IOERR.GT.0) CALL M_HFIX(LUN,TXT1(1:LENT),NRECL,IOERR)
C
              IF(IOERR.NE.0) THEN
                  GOTO 8000
              ELSE
                  WRITE(LUNTTO,'(1X,A,I5)')
     +             'File successfully opened with record length',NRECL
              ENDIF
          ENDIF
C
C     Open a formatted direct access file - recl = 80
C
      ELSEIF(MMODE.EQ.6) then
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='FORMATTED'
     1     ,ACCESS='DIRECT',RECL=80,IOSTAT=IOERR,ERR=8000
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='OLD',READONLY,SHARED)
#endif
#if ( defined(HPUX) || defined(SGI) )
     +     ,STATUS='OLD',READONLY)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) ) && ( !defined(HPUX) ) && ( !defined(SGI) )
     +     ,STATUS='OLD')
#endif
C
C     Open a root file - in fact just pass filename back to open routine
C
      ELSEIF(MMODE.EQ.8) then
        tfile = txt1(1:lent)
        goto 9000
C
C     Open a new file
C
      ELSEIF(MMODE.EQ.-1) THEN
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='UNFORMATTED'
     1     ,ACCESS='SEQUENTIAL',IOSTAT=IOERR,ERR=4100
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='NEW',CARRIAGECONTROL='NONE',SHARED)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) )
     +     ,STATUS='NEW')
#endif

          GOTO 6000
4100      CONTINUE
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='UNFORMATTED'
     1     ,ACCESS='SEQUENTIAL',IOSTAT=IOERR,ERR=8000
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='UNKNOWN',CARRIAGECONTROL='NONE',SHARED)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) )
     +     ,STATUS='UNKNOWN')
#endif

          if(iabs(nmode).le.50)
     +     CALL M_EMSG('MN_FIL','File ' // TXT1(1:LENT) //
     1     ' will be overwritten')
C
      ELSEIF(MMODE.EQ.-2) THEN
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='FORMATTED'
     1     ,ACCESS='SEQUENTIAL',IOSTAT=IOERR,ERR=4200
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='NEW',CARRIAGECONTROL='FORTRAN',SHARED)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) )
     +     ,STATUS='NEW')
#endif

          GOTO 6000
4200      CONTINUE
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='FORMATTED'
     1     ,ACCESS='SEQUENTIAL',IOSTAT=IOERR,ERR=8000
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='UNKNOWN',CARRIAGECONTROL='FORTRAN',SHARED)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) )
     +     ,STATUS='UNKNOWN')
#endif

          if(iabs(nmode).le.50)
     +     CALL M_EMSG('MN_FIL','File ' // TXT1(1:LENT) //
     1     ' will be overwritten')
C
      ELSEIF(MMODE.EQ.-3) THEN
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='FORMATTED'
     1     ,ACCESS='SEQUENTIAL',IOSTAT=IOERR,ERR=4300
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='NEW',CARRIAGECONTROL='LIST',SHARED)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) )
     +     ,STATUS='NEW')
#endif

          GOTO 6000
4300      CONTINUE
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='FORMATTED'
     1     ,ACCESS='SEQUENTIAL',IOSTAT=IOERR,ERR=8000
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='UNKNOWN',CARRIAGECONTROL='LIST',SHARED)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) )
     +     ,STATUS='UNKNOWN')
#endif

          if(iabs(nmode).le.50)
     +     CALL M_EMSG('MN_FIL','File ' // TXT1(1:LENT) //
     1     ' will be overwritten')
C
      ELSEIF(MMODE.EQ.-4 .or. MMODE.EQ.-7) THEN
          nrecl = nrclhb
          if(nrecl.le.0) nrecl = 1024
          if(mmode.eq.-4) then
            CALL HROPEN(LUN,'MN_HBOUT',TXT1(1:LENT),'NP',NRECL,IOERR)
          else
            CALL HROPEN(LUN,'MRGOUT',TXT1(1:LENT),'NP',NRECL,IOERR)
          endif
          IF(IOERR.NE.0) THEN
              GOTO 8000
          ENDIF
C
C     Open an old file, but it can be overwritten
C
      ELSEIF(MMODE.EQ.-5) THEN
          nrecl = nrclhb
          CALL HROPEN(LUN,'MN_HBOUT',TXT1(1:LENT),'UP',NRECL,IOERR)
          IF(IOERR.NE.0) THEN
              GOTO 8000
          ENDIF
C
C     Open a formatted direct access file - recl = 80
C
      ELSEIF(MMODE.EQ.-6) THEN
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='FORMATTED'
     1     ,ACCESS='DIRECT',RECL=80,IOSTAT=IOERR,ERR=4600
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='NEW',SHARED)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) )
     +     ,STATUS='NEW')
#endif

          GOTO 6000
4600      CONTINUE
          OPEN(UNIT=LUN,FILE=TXT1(1:LENT)
     1     ,FORM='FORMATTED'
     1     ,ACCESS='DIRECT',RECL=80,IOSTAT=IOERR,ERR=8000
#if ( defined(VMS) || defined(ALPHA) )
     +     ,STATUS='UNKNOWN',SHARED)
#endif
#if ( !defined(VMS) ) && ( !defined(ALPHA) )
     +     ,STATUS='UNKNOWN')
#endif

          if(iabs(nmode).le.50)
     +     CALL M_EMSG('MN_FIL','File ' // TXT1(1:LENT) //
     1     ' will be overwritten')
C
C     Unknown mode
C
      ELSE
          TXTERR = ' '
          WRITE(TXTERR,'('' MN_FIL: Unknown mode for opening a file''
     1     ,I4)') NMODE
          CALL MN_ERR('MN_FIL',TXTERR)
          IERR = 3
          GOTO 9000
      ENDIF
C
C     Get the full filename and print it out
C
6000  CONTINUE
      INQUIRE(UNIT=LUN,NAME=TXT2)
      if(txt2.ne.' ') then
          TFILE = TXT2
      else
          tfile = txt1(:lent)
      endif
      lent  = max0(1,lnblnk(tfile))
      IF(NMODE.GT.0 .AND. NMODE.LT.10) THEN
          WRITE(LUNTTO,12100) LUN,TFILE(:lent)
12100     FORMAT(' Reading histograms from unit',I4
     1     ,/,' File: ',A)
      ELSEIF(NMODE.GE.10 .AND. NMODE.LT.20) THEN
          WRITE(LUNTTO,12110) LUN,TFILE(:lent)
12110     FORMAT(' Reading functions from unit',I4
     1     ,/,' File: ',A)
      ELSEIF(NMODE.GE.20 .AND. NMODE.LT.30) THEN
          WRITE(LUNTTO,12120) LUN,TFILE(:lent)
12120     FORMAT(' Reading commands from unit',I4
     1     ,/,' File: ',A)
      ELSEIF(NMODE.LT.0 .AND. NMODE.GT.-10) THEN
          WRITE(LUNTTO,12200) LUN,TFILE(:lent)
12200     FORMAT(' Writing histograms to unit',I4
     1     ,/,' File: ',A)
      ELSEIF(NMODE.LE.-10 .AND. NMODE.GT.-20) THEN
          WRITE(LUNTTO,12210) LUN,TFILE(:lent)
12210     FORMAT(' Writing functions to unit',I4
     1     ,/,' File: ',A)
      ELSEIF(NMODE.LE.-20 .AND. NMODE.GT.-30) THEN
          WRITE(LUNTTO,12220) LUN,TFILE(:lent)
12220     FORMAT(' Writing commands to unit',I4
     1     ,/,' File: ',A)
      ELSEIF(NMODE.LE.-30 .AND. NMODE.GT.-40) THEN
          WRITE(LUNTTO,12230) LUN,TFILE(:lent)
12230     FORMAT(' Writing dump output to unit',I4
     1     ,/,' File: ',A)
      ENDIF
      GOTO 9000
C
8000  CONTINUE
      IF(IABS(NMODE).LE.50) THEN
          TXTERR = ' '
          LENT = MIN0(LNBLNK(TXT1),60)
          IF(IOERR.GT.0) THEN
              WRITE(TXTERR,12150) IOERR,LUN
12150         FORMAT('FORTRAN error',I5,' opening unit',I4)
          ELSE
              WRITE(TXTERR,12152) IOERR,LUN
12152         FORMAT('Error',I5,' opening unit',I4)
          ENDIF
          CALL M_EMSG('MN_FIL',TXTERR)
          TXTERR = 'File: ' // txt1(1:lent)
          CALL MN_ERR('MN_FIL',TXTERR)
      ENDIF
      IERR = 2
C
      IF(LUNi.LE.0 .AND. LUN.GT.0) THEN
          CALL CLEO_FRELUN(LUN,'MN_FIL')
      ENDIF
C
 9000 CONTINUE
      END
