      SUBROUTINE MN_HLP(IDELIM,IERR)
C
C     The VMS version of Mn_Fit help uses VMS Help directly. On other computers
C     the Mn_Fit imitation has to be used.
C     The Mn_Fit version of VMS Help for Unix
C     assumes that there is a direct access file MN_FIT_HELP:MN_HELP.FIL
C     and a sequential file MN_FIT_HELP:MN_HDIR.FIL which contains all
C     the pointers to the help topics.
C     These files can be made using the deck MNHLPMKE in the patch JOBS
C     which also contains the link files.
C
      implicit none
C
#include "mndir.inc"
#include "mnflg.inc"
#include "mnlun.inc"
C
      integer idelim,ierr
C
#if ( !defined(MN_HLP) ) && ( defined(VMS) )
      EXTERNAL LIB$PUT_OUTPUT,LIB$GET_INPUT
      INCLUDE 'SYS$LIBRARY:FORSYSDEF.TLB($HLPDEF)'
C
      CHARACTER*80 TOPIC
      integer nfinal,nfindr,invoke,lun,ntopic,istr,nchar
      integer lnblnk,istrnq
      external lnblnk,istrnq
C
#endif
#if ( defined(MN_HLP) || !defined(VMS) )
#include "mncmd.inc"
#include "mndbg.inc"
*
      integer mhelp
      PARAMETER (MHELP=600)
      CHARACTER*30 HLPNAM(MHELP),TOPIC,HLPTRE(10)
      INTEGER NHELP,IHLPLV(MHELP),IHLPN1(MHELP),IHLPN2(MHELP)
      integer lunhlp
      integer nfinal,nfindr,level,n1,n2,ntree,nstart,nstop,nambig
     + ,ndone,ngood,nspace,i,ncmd,icmd,nmatch,lenf,lent
      integer lnblnk,icmtyq,icmlst
      external icmtyq,icmlst
*
      SAVE HLPNAM
      SAVE NHELP,IHLPLV,IHLPN1,IHLPN2
      save lunhlp
*
      INTEGER IN1TRE(0:10),IN2TRE(0:10)
      INTEGER MLIST
      PARAMETER (MLIST=20)
      INTEGER ILIST(MLIST),IAMBIG(MHELP)
      CHARACTER*80 TXT1,TXT2
      CHARACTER*20 TFORMAT
      character*80 thffil
      LOGICAL QOPEN
      integer ndate,ntime,ind,jerr
      integer  systemf,unlinkf
      external systemf,unlinkf
#endif
#if ( !defined(VMS) )
      CHARACTER*255 TMPDIR
      INTEGER TMPLEN
#endif
C
      CHARACTER*255 CONCAT,CONCT0
      CHARACTER*80 THLPNM,THDRNM
      CHARACTER*80 FNLNAM,FDRNAM
C
      LOGICAL QSTART,QHELP,QLIST,QALL,qhformat
C
#if ( !defined(MN_HLP) ) && ( defined(VMS) )
      DATA THLPNM/'mn_fit.hlb'/
      DATA THDRNM/' '/
#endif
#if ( defined(MN_HLP) || !defined(VMS) )
      DATA THLPNM/'mn_help.fil'/
      DATA THDRNM/'mn_hdir.fil'/
      DATA NHELP/0/
#endif

#if ( !defined(VMS) )
      data thffil/'/tmp/mn_fit_help_XXXXXX_YYYY.tmp'/
#endif
#if ( defined(MN_HLP) ) && ( defined(VMS) )
      data thffil/'mn_fit_help_XXXXXX_YYYY.tmp'/
#endif

      DATA QSTART/.TRUE./,QHELP/.FALSE./
C
      IERR=0
C
      FNLNAM = ' '
      FNLNAM = CONCT0(TMNHLP,THLPNM)
      FDRNAM = CONCT0(TMNHLP,THDRNM)
      NFINAL = LNBLNK(FNLNAM)
      NFINDR = LNBLNK(FDRNAM)
C
#if ( !defined(MN_HLP) ) && ( defined(VMS) )
C
C     VMS version of HELP using VMS help
C
      IF(NFINAL.LE.0) GOTO 9000
      INVOKE = 1
C
C     CHECK THAT LIBRARY EXISTS
C
      IF(QSTART) THEN
          QSTART = .FALSE.
          CALL CLEO_GETLUN(LUN,'MN_HLP')
          OPEN(UNIT=LUN,FILE=FNLNAM(1:NFINAL)
     1     ,TYPE='OLD',SHARED,READONLY,ERR=9000)
          CLOSE(UNIT=LUN)
          CALL CLEO_FRELUN(LUN,'MN_HLP')
          QHELP = .TRUE.
      ENDIF
C
C     SEE WHAT TOPIC I WANT HELP ON
C
      IF(.NOT.QHELP) then
          CALL ZERTYQ('.FALSE.')
          RETURN
      ENDIF
      TOPIC = ' '
      NTOPIC = 1
      IF(IDELIM.EQ.0) THEN
          CALL WAITYQ('Give HELP topic or <CR>: ')
          ISTR = ISTRNQ(.TRUE.,TOPIC,NCHAR)
          CALL ZERTYQ('.FALSE.')
          IF(NCHAR.LE.0) THEN
              NTOPIC = 1
              TOPIC = ' '
          ELSE
              NTOPIC = NCHAR
          ENDIF
      ENDIF
C
      IF(INVOKE.NE.0) THEN
          CALL LBR$OUTPUT_HELP(LIB$PUT_OUTPUT,0
     1     ,TOPIC(1:NTOPIC),FNLNAM(1:NFINAL)
     2     ,HLP$M_PROMPT + HLP$M_HELP,LIB$GET_INPUT)
      ENDIF
C
C     MAKE SURE TYPSCN BUFFER IS CLEARED OUT
C
      CALL ZERTYQ('.FALSE.')
C
      RETURN
C
 9000 CONTINUE
      QHELP = .FALSE.
      WRITE(LUNTTO,'(//,'' *** HELP library: '',A
     1 ,/,'' *** does not exist'')') FNLNAM
C
#endif
#if ( defined(MN_HLP) || !defined(VMS) )
      IF(QSTART) THEN
          QSTART = .FALSE.
          NHELP = 0
          CALL CLEO_GETLUN(LUNHLP,'MN_HLP')
          call mn_fil(42,luntmp,fdrnam(:nfindr),idelim,ierr)
          if(ierr.ne.0) goto 9000
*
          call mn_fil(46,lunhlp,fnlnam(:nfinal),idelim,ierr)
          if(ierr.ne.0) goto 9000
C
1000      CONTINUE
          READ(LUNTMP,'(1X,I4,1X,A,I6,I6)',ERR=9100,END=1100)
     +     LEVEL,TOPIC,N1,N2
          NHELP = NHELP + 1
          IF(NHELP.GE.MHELP) THEN
              CALL MN_ERR('MN_HLP','Ran out of space for help topics')
              NHELP = NHELP - 1
              GOTO 1100
          ENDIF
          IHLPLV(NHELP) = LEVEL
          HLPNAM(NHELP) = TOPIC
          IHLPN1(NHELP) = N1
          IHLPN2(NHELP) = N2
          GOTO 1000
1100      CONTINUE
          hlpnam(nhelp+1) = ' '
          WRITE(TXTMES,'('' MN_HLP: I have found '',I3
     +     ,'' HELP topics'')') NHELP
          CALL MN_MES(LUNTTO,'ME',TXTMES)
          CLOSE(UNIT=LUNTMP)
          QHELP = .TRUE.
*
*         Make the filename for pager output
*
C     Modified to respect $TMPDIR on Unix
C     -- Kevin B. McCarty, 7 Jan 2005
#if ( !defined( VMS ) )
          CALL GETENVF('TMPDIR', TMPDIR)
          TMPLEN = LNBLNK(TMPDIR)
          IF(TMPLEN.EQ.0) THEN
              TMPDIR = '/tmp'
              TMPLEN = 4
          ENDIF
          thffil = TMPDIR(1:TMPLEN)//'/mn_fit_help_XXXXXX_YYYY.tmp'
#endif
          call m_rtim(ndate,ntime)
          ind = index(thffil,'XXXXXX')
          write(thffil(ind:ind+5),'(i6.6)') ndate
          ind = index(thffil,'YYYY')
          write(thffil(ind:ind+3),'(i4.4)') ntime
          lenf = lnblnk(thffil)
          write(txtmes,'('' MN_HLP: Help pager filename is: '',A)')
     +     thffil(:lenf)
          call mn_mes(luntto,'ME',txtmes)
      ELSEIF(.NOT.QHELP) THEN
          CALL MN_ERR('MN_HLP','Help is not available')
          RETURN
      ENDIF
C
C     Allow a / to be in the command name also
C
      CALL ICMSYM(THPSYM)
C
C     Got a help command
C     First treat special cases ? for list of topics and * for everything
C     at this level
C
      NTREE    = -1
      NSTART   = 1
      NSTOP    = NHELP
      qhformat = tpager.ne.' '
2000  CONTINUE
      QLIST  = .FALSE.
      QALL   = .FALSE.
      NAMBIG = 0
      IF(NTREE.LT.0 .AND. IDELIM.LT.0) THEN
C
C         Print out the header and the list of topics
C
          DO 2050 I=1,NHELP
              IF(HLPNAM(I).EQ.'HELP') THEN
                  NCMD = I
                  GOTO 2500
              ENDIF
2050      CONTINUE
C
      ELSEIF(NTREE.LE.0) THEN
          CALL WAITYQ('Give topic: ')
          NTREE = 0
          IN1TRE(NTREE) = 1
          IN2TRE(NTREE) = NHELP
      ELSE
          TXT1 = 'Give ' // HLPTRE(NTREE)
          TXT2 = CONCAT(TXT1,'subtopic:')
          TXT1 = TXT2
          LENT = LNBLNK(TXT1)
          CALL WAITYQ(TXT1(1:LENT+1))
      ENDIF
      ICMD = ICMTYQ(.TRUE.,IDELIM,HLPNAM(NSTART))
      CALL ICMSTR(TOPIC)
      IF(IDELIM.GT.0) THEN
          IF(IDELIM.EQ.ICHAR('*')) THEN
              QALL = .TRUE.
              NAMBIG = 0
              DO I=NSTART,NHELP
                  NCMD = I
                  IF(NCMD.GT.NSTOP) GOTO 2110
                  IF(IHLPLV(NCMD).LT.NTREE+1) GOTO 2110
                  IF(IHLPLV(NCMD).EQ.NTREE+1) THEN
                      NAMBIG = NAMBIG + 1
                      IAMBIG(NAMBIG) = NCMD
                  ENDIF
              ENDDO
              NDONE = 0
              GOTO 2400
          ELSEIF(IDELIM.EQ.ICHAR('?')) THEN
              QLIST = .TRUE.
              NTREE = MAX0(-1,NTREE-1)
              CALL ZERTYQ('.FALSE.')
              GOTO 2500
          ENDIF
C
          CALL ZERTYQ('.TRUE.')
          GOTO 9900
      ENDIF
C
      IF(ICMD.LT.0) THEN
          NTREE = NTREE - 1
          IF(NTREE.LT.0) GOTO 9900
          NSTART = IN1TRE(NTREE)
          NSTOP  = IN2TRE(NTREE)
          GOTO 2000
      ENDIF
C
      IF(ICMD.EQ.0) THEN
          NMATCH = ICMLST(MLIST,ILIST)
          IF(NMATCH.EQ.0) THEN
              CALL MN_ERR('MN_HLP','Unknown HELP topic: ' // TOPIC)
              GOTO 2000
          ENDIF
          NAMBIG = 0
          DO 2100 I=1,MIN(NMATCH,MLIST)
              NCMD = NSTART + ILIST(I) - 1
              IF(NCMD.GT.NSTOP) GOTO 2110
              IF(IHLPLV(NCMD).LT.NTREE+1) GOTO 2110
              IF(IHLPLV(NCMD).GT.NTREE+1) GOTO 2100
              NAMBIG = NAMBIG + 1
              NGOOD  = ILIST(I)
              IAMBIG(NAMBIG) = NCMD
 2100     CONTINUE
      ENDIF
*
 2110 CONTINUE
*
      IF(ICMD.EQ.0 .AND. NAMBIG.EQ.0) THEN
          CALL MN_MES(LUNTTO,'ME',' Invalid HELP topic: ' // TOPIC)
          GOTO 2000
      ELSEIF(NAMBIG.GT.1) THEN
          CALL MN_MES(LUNTTO,'I',' Ambiguous HELP topic:')
          DO I=1,NAMBIG
              CALL MN_MES(LUNTTO,'I',' ' // HLPNAM(IAMBIG(I)))
          ENDDO
          CALL MN_MES(LUNTTO,'E',' ')
          NDONE = 0
          GOTO 2400
      ELSEIF(ICMD.EQ.0) THEN
          NCMD = NSTART + NGOOD - 1
*
*     Check that we have not jumped to another help topic
*
      ELSE
          NCMD = NSTART + ICMD  - 1
          IF(NCMD.GT.NSTOP) THEN
              CALL MN_MES(LUNTTO,'ME',' Invalid HELP topic ' // TOPIC)
              GOTO 2000
          ENDIF
      ENDIF
      GOTO 2500
C
 2400 CONTINUE
      IF(NAMBIG.GT.1 .AND. NDONE.GT.0) NTREE = NTREE - 1
      NDONE = NDONE + 1
      IF(NDONE.GT.NAMBIG) THEN
          CALL ZERTYQ('.FALSE.')
          GOTO 2000
      ENDIF
      NCMD = IAMBIG(NDONE)
C
 2500 CONTINUE
      NTREE = NTREE + 1
      IF(.NOT.QLIST .AND. NTREE.GT.0) HLPTRE(NTREE) = HLPNAM(NCMD)
C
C     Find the beginning and end of this HELP subtopics
C
      IF(NTREE.EQ.0) THEN
          NSTART = 1
          NSTOP  = NHELP
          IN1TRE(NTREE) = NSTART
          IN2TRE(NTREE) = NSTOP
      ELSEIF(.NOT.QLIST) THEN
          NSTART = NCMD + 1
          NSTOP  = NHELP
          DO 2600 I=NSTART,NSTOP
              IF(IHLPLV(I).LE.NTREE) THEN
                  NSTOP = I - 1
                  GOTO 2610
              ENDIF
2600      CONTINUE
2610      CONTINUE
          IN1TRE(NTREE) = NSTART
          IN2TRE(NTREE) = NSTOP
      ENDIF
C
C     Work down the tree if this is not the end of the line
C
      IF(NAMBIG.LE.1 .AND. IDELIM.EQ.0) GOTO 2000
C
C     Now we've got the Help topic - print it
C     or pipe the help into the pager command
C
      if(qhformat) then
          lenf   = lnblnk(thffil)
          call mn_fil(-52,luntmp,thffil(:lenf),idelim,ierr)
          if(ierr.ne.0) qhformat = .false.
      endif
C
C     Go to topic list if that is what was asked for
C
      IF(QLIST) GOTO 3150
*
      DO 3000 I=1,NTREE
          TFORMAT = '(  X,A)'
          NSPACE = 1 + 2*(I-1)
          WRITE(TFORMAT(2:3),'(I2)') NSPACE
          if(qhformat) then
              write(luntmp,fmt=tformat) hlptre(i)
          else
              WRITE(TXTMES,FMT=TFORMAT) HLPTRE(I)
              CALL MN_MES(LUNTTO,'I',TXTMES)
          endif
3000  CONTINUE
      if(qhformat) then
          write(luntmp,'(1x)')
      else
          CALL MN_MES(LUNTTO,'I',' ')
      endif
      TFORMAT = '(  X,A)'
      NSPACE = MAX0(1,1 + 2*(NTREE-1))
      WRITE(TFORMAT(2:3),'(I2)') NSPACE
*
      DO 3100 I=IHLPN1(NCMD),IHLPN2(NCMD)
          TXT1 = ' '
          READ(LUNHLP,REC=I,FMT='(A)') TXT1
          LENT = MIN0(80-NSPACE,MAX0(1,LNBLNK(TXT1)))
          if(qhformat) then
              write(luntmp,fmt=tformat) txt1(1:lent)
          else
              WRITE(TXTMES,FMT=TFORMAT) TXT1(1:LENT)
              CALL MN_MES(LUNTTO,'I',TXTMES)
          endif
3100  CONTINUE
C
C     Now find the subtopics
C
3150  CONTINUE
      CALL MN_MES(LUNTTO,'I',' ')
      IF(NTREE.LT.1) THEN
          txtmes = ' Information available:'
      ELSE
          txtmes = ' Additional information available:'
      ENDIF
      if(qhformat) then
          write(luntmp,'(a)') txtmes
          write(luntmp,'(1x)')
      else
          CALL MN_MES(LUNTTO,'I',txtmes)
          CALL MN_MES(LUNTTO,'IE',' ')
      endif
C
C     Check if there are any subtopics
C
      NSTART = IN1TRE(NTREE)
      NSTOP  = IN2TRE(NTREE)
C
      IF(NSTOP.LT.NSTART) THEN
          IF(NAMBIG.LE.1) THEN
              NTREE = NTREE - 1
              NSTART = IN1TRE(NTREE)
              NSTOP  = IN2TRE(NTREE)
          ENDIF
          goto 3300
      ENDIF
C
C     Write out the list of subtopics
C
      N1 = 1
      DO 3200 I=NSTART,NSTOP
          IF(IHLPLV(I).GT.NTREE+1) THEN
C
C           Make sure the text buffer gets written if this is the last subtopic
C
            if(i.eq.nstop) then
              if(qhformat) then
                write(luntmp,'(2X,A)') txt1(1:lent)
              else
                write(txtmes,'(2X,A)') txt1(1:lent)
                call mn_mes(luntto,'I',txtmes)
              endif
              txt1 = ' '
            endif
            goto 3200
          ENDIF
          IF(N1.EQ.1) THEN
              TXT2 = HLPNAM(I)
          ELSE
              TXT2 = TXT1(1:N1-1) // HLPNAM(I)
          ENDIF
          TXT1 = TXT2
          LENT = MAX0(1,LNBLNK(TXT1))
          IF(I.EQ.NSTOP .OR. LENT.GT.70) THEN
              IF(LENT.GT.78) THEN
                  if(qhformat) then
                      write(luntmp,'(2X,A)') txt1(1:n1-1)
                  else
                      WRITE(TXTMES,'(2X,A)') TXT1(1:N1-1)
                      CALL MN_MES(LUNTTO,'I',TXTMES)
                  endif
                  TXT1 = HLPNAM(I)
                  IF(I.EQ.NSTOP) THEN
                      LENT = MAX0(1,LNBLNK(TXT1))
                      if(qhformat) then
                          write(luntmp,'(2X,A)') txt1(1:lent)
                      else
                          WRITE(TXTMES,'(2X,A)') TXT1(1:LENT)
                          CALL MN_MES(LUNTTO,'I',TXTMES)
                      endif
                  ENDIF
              ELSE
                  if(qhformat) then
                      write(luntmp,'(2X,A)') txt1(1:lent)
                  else
                      WRITE(TXTMES,'(2X,A)') TXT1(1:LENT)
                      CALL MN_MES(LUNTTO,'I',TXTMES)
                  endif
                  TXT1 = ' '
              ENDIF
          ENDIF
C
          LENT = LNBLNK(TXT1)
          IF(LENT.GT.0) THEN
              N1 = (LENT / 11) * 11 + 12
          ELSE
              N1 = 1
          ENDIF
3200  CONTINUE
3300  CONTINUE
      if(qhformat) then
          write(luntmp,'(1X)')
      else
          CALL MN_MES(LUNTTO,'IE',' ')
      endif
*
      if(qhformat) then
          call zertyq('.FALSE.')
          close(luntmp)
          lent = lnblnk(tpager)
          txt1 = tpager(:lent) // ' ' // thffil(:lenf)
          lent = lnblnk(txt1)
*         Look at the temporary help file
          if(qdebug) write(6,'('' Trying to shell command:''
     +     ,/,1X,''<'',A,''>'')') txt1(1:lent)
          ierr = systemf(txt1(1:lent))
*         Delete the temporary help file
          if(qdebug) write(6,'('' Trying to delete file: '',A)')
     +     thffil(:lenf)
          jerr = unlinkf(thffil(:lenf))
          if(jerr.ne.0) then
            call m_emsg('MN_HLP'
     +       ,'Error deleting file with help text. Remove any')
            call m_emsg('MN_HLP'
     +       ,'/tmp/mn_fit_help... files when Mn_Fit session finished')
          endif
      endif
*
      IF(NAMBIG.GT.1) THEN
          GOTO 2400
      ELSE
          GOTO 2000
      ENDIF
C
9000  CONTINUE
      CALL MN_ERR('MN_HLP','Error opening HELP files -' //
     + ' no HELP is available')
      NHELP = 0
      INQUIRE(UNIT=LUNHLP,OPENED=QOPEN)
      IF(QOPEN) CLOSE(UNIT=LUNHLP)
      INQUIRE(UNIT=LUNTMP,OPENED=QOPEN)
      IF(QOPEN) CLOSE(UNIT=LUNTMP)
      GOTO 9900
C
9100  CONTINUE
      CALL MN_ERR('MN_HLP','Error reading HELP file -' //
     + ' no HELP is available')
      NHELP = 0
      INQUIRE(UNIT=LUNHLP,OPENED=QOPEN)
      IF(QOPEN) CLOSE(UNIT=LUNHLP)
      INQUIRE(UNIT=LUNTMP,OPENED=QOPEN)
      IF(QOPEN) CLOSE(UNIT=LUNTMP)
      GOTO 9900
C
9900  CONTINUE
      CALL ICMSYM(TSPSYM)
#endif

      END
