      SUBROUTINE MIN_DRAW(FCN,NNUM,NUMBERS,FUTIL)
C
C     Draws FCN versus Chi**2 or Likelihood or Fit Probability
C
      EXTERNAL FCN,FUTIL
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      DOUBLE PRECISION PVAL(MINMAX)
      DOUBLE PRECISION FMIN,FEDM,ERRDEF,VAL,ERROR,BND1,BND2,WF,G
      CHARACTER*10 TPNAME
      REAL F
C
      CHARACTER*10 TCOMM,TYAXIS
      CHARACTER*53 PAGE(32)
      CHARACTER*1 STERN,PLUS,LTRI,MINUS,PUNKT,LTRT
      LOGICAL GG(5)
      REAL*4 DD(5),NUMBERS(*)
C
      DATA STERN/'*'/,PLUS/'+'/,LTRI/'I'/,MINUS/'-'/
     1 ,PUNKT/'.'/,LTRT/'T'/
C
C     Change the output unit
      ISYSWR = LUNDMP
C
      DO 100 I=1,5
          IF(I.LE.NNUM) THEN
              GG(I) = .TRUE.
          ELSE
              GG(I) = .FALSE.
          ENDIF
          DD(I)=NUMBERS(I)
100   CONTINUE
C
      CALL MNSTAT(FMIN,FEDM,ERRDEF,NPARI,NPARX,ISTAT)
      UP = SNGL(ERRDEF)
C
      IF(.NOT.GG(1)) THEN
1000      CONTINUE
          TCOMM = ' '
          CALL WAITYQ('Give variable name or number to plot: ')
          nlook = ivltyq(.true.,idelim)
          if(idelim.le.0 .and. nlook.ne.0) then
              if(nlook.le.0 .or. nlook.gt.nparx) then
                  write(TXTERR,'(''Variable number must be between''
     +             '' 1 and'',I3)') nparx
                  CALL MN_ERR('MIN_DRAW',TXTERR)
                  GOTO 9000
              else
                  nf = jminfx(nlook)
                  np = jminpx(nlook)
                  if(qsnorm .and. nf.eq.0) then
                      tcomm = 'NORM00'
                  else
                      tcomm = tparf(np,nf)
                  endif
                  goto 1110
              endif
          else
              call restyq
          endif
*
          NCHR = ISTTYQ(.TRUE.,IDELIM,TCOMM)
          IF(NCHR.LT.0) GOTO 9000
          NPART = 0
          NLOOK = 0
          if(qsnorm) then
              if(tcomm.eq.'NORM00') then
                  nlook = 1
                  nf    = 0
                  np    = 1
              else
                  npart = 1
              endif
          endif
          DO 1100 IF=1,NFUN_MN
              IF(IUSEF(IF).EQ.0) GOTO 1100
              DO 1050 IP=1,IPARF(IF)
                  NPART = NPART + 1
                  IF(TCOMM.EQ.TPARF(IP,IF)) THEN
                      NF = IF
                      NP = IP
                      NLOOK = NPART
                      GOTO 1110
                  ENDIF
1050          CONTINUE
1100      CONTINUE
          LENT = LENOCC(TCOMM)
          TXTERR = 'Variable ' // TCOMM(1:LENT) // ' not found'
          CALL MN_ERR('MIN_DRAW',TXTERR)
          GOTO 9000
1110      CONTINUE
      else
          nlook = numbers(1)
          if(nlook.le.0 .or. nlook.gt.nparx) then
              write(TXTERR,'(''Variable number must be between''
     +         '' 1 and'',I3)') nparx
              CALL MN_ERR('MIN_DRAW',TXTERR)
              GOTO 9000
          endif
          nf = jminfx(nlook)
          np = jminpx(nlook)
          if(qsnorm .and. nf.eq.0) then
              tcomm = 'NORM00'
          else
              tcomm = tparf(np,nf)
          endif
      ENDIF
C
      CALL MNPOUT(NLOOK,TPNAME,VAL,ERROR,BND1,BND2,IVARBL)
      IF(.NOT.GG(2)) DD(2) = SNGL(BND1)
      IF(.NOT.GG(3)) DD(3) = SNGL(BND2)
      IF(.NOT.GG(2).AND..NOT.GG(3)) THEN
          DD(2) = SNGL(VAL-2.0D0*ERROR)
          DD(3) = SNGL(VAL+2.0D0*ERROR)
      ENDIF
      IF(.NOT.GG(4)) DD(4) = SNGL(FMIN-20.0D0*UP)
      IF(.NOT.GG(5)) DD(5) = SNGL(FMIN+20.0D0*UP)
      DO 1200 I=1,NPARX
          CALL MNPOUT(I,TPNAME,PVAL(I),ERROR,BND1,BND2,IVARBL)
1200  CONTINUE
C
      IF(.NOT.GG(1)) THEN
          IF(IDELIM.LT.0) WRITE(ISYSWR,'(1X,A,'' axis'')') TCOMM
          CALL MN_BLM(2,0,IDELIM,'MINUIT DRAW'
     +     ,NBIN,DD(2),DD(3),NNUM,IERR)
          IF(IERR.NE.0) GOTO 9000
C
          IF(NFITTP.EQ.0) THEN
              TYAXIS = 'Chi**2'
          ELSE
              TYAXIS = 'Likelihood'
          ENDIF
          IF(IDELIM.LT.0) WRITE(ISYSWR,'(1X,A,'' axis'')') TYAXIS
          CALL MN_BLM(2,0,IDELIM,'MINUIT DRAW'
     +     ,NBIN,DD(4),DD(5),NNUM,IERR)
          IF(IERR.NE.0) GOTO 9000
      ENDIF
C
      XLOQ=DD(2)
      XHIQ=DD(3)
      YLOQ=DD(4)
      YHIQ=DD(5)
C
      LENT = LENOCC(TCOMM)
      WRITE(ISYSWR,21000,IOSTAT=IOERR) TCOMM(1:LENT),NLOOK
21000 FORMAT(/' *** PROCEED TO PLOT FCN AS FUNCTION OF ',A
     1 ,'(',I2,') ***')
      WRITE(ISYSWR,21100,IOSTAT=IOERR) XLOQ,XHIQ
21100 FORMAT(' *** RANGE OF VARIABLE:',1PG15.6,2X,1PG15.6)
      WRITE(ISYSWR,21200,IOSTAT=IOERR) YLOQ,YHIQ
21200 FORMAT(' *** RANGE OF FUNCTION:',1PG15.6,2X,1PG15.6)
      WRITE(ISYSWR,'(1X)')
C
C     --X=2....52,  Y=32....1 --
C
      DO 3100 I=1,32
          PAGE(I)=' '
3100  CONTINUE
      DO 3110 I=1,53
          PAGE(1)(I:I) = MINUS
          PAGE(32)(I:I)= MINUS
3110  CONTINUE
      DO 3120 I=2,52,5
          PAGE(1)(I:I) = PUNKT
          PAGE(32)(I:I)= PUNKT
3120  CONTINUE
      DO 3130 I=1,32
          PAGE(I)(1:1) = LTRI
          PAGE(I)(53:53)= LTRI
3130  CONTINUE
      DO 3140 I=1,31,10
          PAGE(I)(1:1) = LTRT
          PAGE(I)(53:53)= LTRT
3140  CONTINUE
      DO 3150 I=6,26,10
          PAGE(I)(1:1) = PLUS
          PAGE(I)(53:53)= PLUS
3150  CONTINUE

      DO 4000 I=2,52
          PVAL(NLOOK) = DBLE(XLOQ+(XHIQ-XLOQ)*((I-2)/50.))
          CALL FCN(NPARX,G,WF,PVAL,4,FUTIL)
          F = SNGL(WF)
          NFCN=NFCN+1
          IF(F.LE.YLOQ) THEN
              IYBIN=1
          ELSEIF(F.GE.YHIQ) THEN
              IYBIN=32
          ELSE
              IYBIN=2+(F-YLOQ)*30./(YHIQ-YLOQ)
          ENDIF
          PAGE(IYBIN)(I:I)=STERN
4000  CONTINUE
C
      DO 5000 K=32,1,-1
          IF(MOD(K,5).EQ.2) THEN
              FFFFF=YLOQ+(YHIQ-YLOQ)/30.*(K-2)
              WRITE(ISYSWR,'(1X,1PG13.5,1X,A)',IOSTAT=IOERR) FFFFF
     +         ,PAGE(K)
          ELSE
              WRITE(ISYSWR,'(15X,A)',IOSTAT=IOERR) PAGE(K)
          ENDIF
5000  CONTINUE
      XMIDQ = 0.5 * (XLOQ + XHIQ)
      WRITE(ISYSWR,'(12X,1PG10.3,14X,1PG10.3,14X,1PG10.3)',IOSTAT=IOERR)
     + XLOQ,XMIDQ,XHIQ
C
9000  CONTINUE
C
C     Change back the output unit
C
      RETURN
      END
