      SUBROUTINE MIN_PLOT(FCN,NMODE,FUTIL)
C
C     ROUTINE FOR PLOTTING THE FCN OR THE PROBABILITY AS A FUNCTION
C     OF A VARIABLE
C     NMODE = 1 MEANS PLOT FCN
C     NMODE = 2 MEANS PLOT PROBABILITY
C     NMODE = 3 MEANS PLOT chi**2
C
      EXTERNAL FCN,FUTIL
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mncmd.inc"
#include "mnhpj.inc"
#include "mnlun.inc"
C
      INTEGER IDBIN(2)
      REAL ADLO(2),ADHI(2)
      REAL ACONT(3*3)
C
      DOUBLE PRECISION PVAL(MINMAX),G,F,FMIN,FEDM,ERRDEF,UP,AFCN0
     + ,ERROR,BND1,BND2
      CHARACTER*10 TPNAME
C
      CHARACTER TITLE*80,CONCAT*255
      CHARACTER*10 TCOMM,TNAME(2)
      logical qslim
*
*     Save the fit type
*
      NTPSAV = NFITTP
*
      CALL MNSTAT(FMIN,FEDM,ERRDEF,NPARI,NPARX,ISTAT)
      UP = SNGL(ERRDEF)
C
 1000 CONTINUE
      TCOMM = ' '
      CALL WAITYQ('Give variable name or number to plot: ')
      nlook = ivltyq(.true.,idelim)
      if(idelim.le.0 .and. nlook.ne.0) then
          if(nlook.le.0 .or. nlook.gt.nparx) then
              write(TXTERR,'(''Variable number must be between''
     +         '' 1 and'',I3)') nparx
              CALL MN_ERR('MIN_PLOT',TXTERR)
              GOTO 9000
          else
              nf = jminfx(nlook)
              np = jminpx(nlook)
              if(qsnorm .and. nf.eq.0) then
                  tcomm = 'NORM00'
              else
                  tcomm = tparf(np,nf)
              endif
              goto 1110
          endif
      else
          call restyq
      endif
*
      NCHR = ISTTYQ(.TRUE.,IDELIM,TCOMM)
      IF(NCHR.LE.0) GOTO 9000
      NPART = 0
      NLOOK = 0
      if(qsnorm) then
          if(tcomm.eq.'NORM00') then
              nlook = 1
              nf    = 0
              np    = 1
          else
              npart = 1
          endif
      endif
      DO 1100 IF=1,NFUN_MN
          IF(IUSEF(IF).EQ.0) GOTO 1100
          DO 1050 IP=1,IPARF(IF)
              NPART = NPART + 1
              IF(TCOMM.EQ.TPARF(IP,IF)) THEN
                  NF = IF
                  NP = IP
                  NLOOK = NPART
                  goto 1110
              ENDIF
 1050     CONTINUE
 1100 CONTINUE
 1110 continue
      IF(NLOOK.EQ.0) THEN
          LENT = LENOCC(TCOMM)
          TXTERR = 'Variable: ' // TCOMM(1:LENT) // ' not found'
          CALL MN_ERR('MIN_PLOT',TXTERR)
          GOTO 9000
      ENDIF
C
      CALL MNSTAT(FMIN,FEDM,UP,NPARI,NPARX,ISTAT)
*
*     Get the latest values of all the variables
*
      do npart = 1,nparx
          CALL MNPOUT(NPART,TPNAME,PVAL(NPART),ERROR,BND1,BND2
     +     ,IVARBL)
      enddo
C
      IDBIN(1) = 100
      if(qsnorm .and. nf.eq.0) then
          TNAME(1) = 'NORM00'
          IF(F00LO.EQ.0.0 .AND. F00HI.EQ.0.0) THEN
              ADLO(1) = F00 - 2.0*DF00
              ADHI(1) = F00 + 2.0*DF00
          ELSE
              ADLO(1) = F00LO
              ADHI(1) = F00HI
          ENDIF
      else
          TNAME(1) = TPARF(NP,NF)
          IF(FPARLO(NP,NF).EQ.0.0 .AND. FPARHI(NP,NF).EQ.0.0) THEN
              ADLO(1) = FPAR(NP,NF) - 2.0*DFPAR(NP,NF)
              ADHI(1) = FPAR(NP,NF) + 2.0*DFPAR(NP,NF)
          ELSE
              ADLO(1) = FPARLO(NP,NF)
              ADHI(1) = FPARHI(NP,NF)
          ENDIF
      endif
C
      IF(NMODE.EQ.1 .or. nmode.eq.3) THEN
          IF(nmode.eq.3 .or. NFITTP.EQ.0) THEN
              TNAME(2) = 'Chi**2'
          ELSE
              TNAME(2) = 'Likelihood'
          ENDIF
          ADLO(2) = SNGL(FMIN - 20.0D0*UP)
          ADHI(2) = SNGL(FMIN + 20.0D0*UP)
      ELSE
          TNAME(2) = 'Prob'
          ADLO(2) = 0.0
          ADHI(2) = 1.0
      ENDIF
      TITLE = CONCAT(TNAME(2),'vs')
      TITLE = CONCAT(TITLE,TNAME(1))
C
      IF(IDELIM.LT.0) WRITE(LUNTTO,'(1X,A,'' axis'')') TNAME(1)
      CALL MN_BLM(2,0,IDELIM,'MINUIT PLOT'
     + ,NBIN,ADLO(1),ADHI(1),NNUM,IERR)
      IF(IERR.NE.0) GOTO 9000
C
      IF(IDELIM.LT.0) WRITE(LUNTTO,'(1X,A,'' axis'')') TNAME(2)
      CALL MN_BLM(2,0,IDELIM,'MINUIT PLOT'
     + ,NBIN,ADLO(2),ADHI(2),NNUM,IERR)
      IF(IERR.NE.0) GOTO 9000
      qslim = nnum.gt.0
C
      IDAF  = 98765
      IDBF  = 999
      NDIM  = 1
      NWPPT = 1
      NPNT  = IDBIN(1)
      NWRD   = NPNT * NWPPT
      NBPPT  = 0
      NTMOD2 = 0
      CALL MN_HNW(IDAF,IDBF,NDIM,NWRD,NH,NPTRH,NPTRD,NWH,NBPPT,NTMOD2)
C
      DX = (ADHI(1) - ADLO(1)) / FLOAT(IDBIN(1))
      EDENT = 0.0
      EDLO = +1.0E+30
      EDHI = -1.0E+30
      CALL VZERO_r(ACONT,3)
C
C     GET THE PRESENT MINIMUM VALUE OF THE FUNCTION
C
      AFCN0  = FMIN
      NTPSAV = NFITTP
*
*     Reset the fit type if necessary
*
      if(nmode.eq.2 .or. nmode.eq.3) then
          if(nfittp.eq.1) then
              nfittp = 8
          elseif(nfittp.eq.2) then
              nfittp = 9
          endif
      endif
C
      NMESS = 0
      DO 3000 I=1,NPNT
          X = ADLO(1) + FLOAT(I-1)*DX + 0.5*DX
          PVAL(NLOOK) = DBLE(X)
          CALL FCN(NPARX,G,F,PVAL,4,FUTIL)
C
          IF(NMODE.EQ.1 .or. nmode.eq.3) THEN
              VAL  = SNGL(F)
          ELSE
              DELF = SNGL(F - AFCN0)
              IF(DELF.LT.0.0) THEN
                  NMESS = NMESS + 1
                  IF(NMESS.LE.10) THEN
                      WRITE(TXTMES,'('' MIN_PLOT: A new minimum''
     1                 ,'' has been found with parameter ''
     2                 ,A,'' = '',G12.5)') TNAME(1),PVAL(NLOOK)
                      CALL MN_MES(LUNTTO,'ME',TXTMES)
                  ENDIF
                  DELF = 0.0
              ENDIF
              VAL = PROB(DELF,1)
          ENDIF
          CALL UMNE(I,NH,NPTRD,NDIM,NWPPT,NBPPT,VAL,NERR)
C
          EDENT = EDENT + VAL
          ACONT(2) = ACONT(2) + VAL
          EDLO = AMIN1(EDLO,VAL)
          EDHI = AMAX1(EDHI,VAL)
3000  CONTINUE
      NFITTP   = NTPSAV
C
      NWTOT = NWH + NWRD
      CALL M_RTIM(NHDAT2,NHTIM2)
      NSDAT2 = 0
      NSTIM2 = 0
      CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWRD,IDAF,IDBF,NDIM,NWPPT,NPNT
     1 ,NHDAT2,NHTIM2,NSDAT2,NSTIM2,NTMOD2
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
      CALL MN_PTU(NH,NWTOT,IDAF,IDBF,NPTRH,NPTRD,TITLE
     1 ,'Generated internally',' ',TNAME)
      CALL MN_MSU(IDAF,IDBF,NDIM,NWH,NH)
C
      IF(QDFIT) CALL MN_FRP
      QLEGO = .FALSE.
      QDFUN = .FALSE.
C
      NHPLT = 1
      IPLTIA(NHPLT) = IDAF
      IPLTIB(NHPLT) = IDBF
      IPLTSY(NHPLT) = -1
      IPLTHA(NHPLT) = 0
      IPLTPA(NHPLT) = 0
      IPLTCO(1,NHPLT) = ICOLS(7)
      IPLTCO(2,NHPLT) = ICOLS(8)
      IPLTCO(3,NHPLT) = ICOLS(9)
      IPLTFL(NHPLT) = 1
      IPLTCL(NHPLT) = 1
      IPLTLG(NHPLT) = 0
      NPLTCM(NHPLT) = 0
      NPLTKY(NHPLT) = 0
C
C     CHANGE THE PLOT LIMITS TO WHAT I REQUESTED
C
      YLIMLO = ALIMS(1,2)
      YLIMHI = ALIMS(2,2)
      ALIMS(1,2) = ADLO(2)
      ALIMS(2,2) = ADHI(2)
*
*     For mode 3 the chi**2 is not necessarily the same as the likelihood
*     If default limits were used then let mn_plt work out the limits
*
      if(nmode.eq.3 .and. .not.qslim) then
          alims(1,2) = 0.0
          alims(2,2) = 0.0
      endif
*
*     Draw the plot
*
      CALL MN_DRW(1,NDERR)
      ALIMS(1,2) = YLIMLO
      ALIMS(2,2) = YLIMHI
C
9000  CONTINUE
      nfittp = ntpsav
C
      END
