      SUBROUTINE M_HRECOVER(IDELIM)
C
C------------------------------------------------------------------------------
C     Recovers an Ntuple in a RZ file
C------------------------------------------------------------------------------
C
      implicit none
*
#include "mnflg.inc"
#include "mnlun.inc"
*
      integer idelim
      integer idh,ierr,nrecl,ioerr,lend
      character*80 savdir
*
      logical hexist
      integer  ivltyq,lnblnk
      external ivltyq
*
      call waityq('Give histogram number: ')
      idh = ivltyq(.true.,idelim)
      call mn_nck(idh,idelim,ierr)
      if(ierr.ne.0) goto 9000
      if(idh.le.0) then
        write(txterr,'(I8,'' is not a valid Ntuple identifier'')')
     +   idh
        call mn_err('M_HRECOVER',txterr)
        goto 9000
      endif
*
      if(lunhin.eq.0 .or. fil_hb.eq.' ') then
        txterr = 'You must open the RZ file before calling HRECOVER'
        call mn_err('M_HRECOVER',txterr)
        goto 9000
      endif
      call hcdir(savdir,'R')
      lend = lnblnk(savdir)
      write(6,'('' Current HBOOK directory is: '',A)') savdir(:lend)
*
      call hrendc('MN_HBIN')
      nrecl = nrclhb
      call hropen(lunhin,'MN_HBIN',fil_hb,'UP',nrecl,ioerr)
      if(ioerr.ne.0) then
        lunhin = 0
        fil_hb = ' '
        write(txterr,'(''Could not open file in update mode'')')
        call m_emsg('M_HRECOVER',txterr)
        write(txterr,'(''Reopen file to fetch other histograms'')')
        call mn_err('M_HRECOVER',txterr)
        goto 9000
      endif
      call hcdir(savdir,' ')
*
*      Now try to recover
*
      call hrecov(idh,' ')
*
      call hrendc('MN_HBIN')
      call hropen(lunhin,'MN_HBIN',fil_hb,'SP',nrecl,ioerr)
      if(ioerr.ne.0) then
        lunhin = 0
        fil_hb = ' '
        write(txterr,'(''Failed to reopen RZ file after recovery'')')
        CALL MN_ERR('M_HRECOVER',TXTERR)
        goto 9000
      endif
      call hcdir(savdir,' ')
c
 9000 continue
      end
